/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.signup.dao.impl;

import com.baijia.commons.lang.utils.collection.CollectionUtils;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseLessonDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourseLesson;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class OrgSignupCourseLessonDaoImpl
extends JdbcTemplateDaoSupport<OrgSignupCourseLesson>
implements OrgSignupCourseLessonDao {
    private static final Logger log = LoggerFactory.getLogger(OrgSignupCourseLessonDaoImpl.class);

    @Override
    public Map<Long, OrgSignupCourseLesson> selectSignUpLessons(Collection<Long> userIds, Long classId, Long orgId) {
        String sql = "select org_id,user_id,signup_course_id,sum(lesson_duration) as lesson_duration,count(*) as lesson_count,sum(amount) as amount from yunying.tx_signup_course_lesson where org_id=:orgId and class_id=:classId and lesson_type=:type and user_id in (:userIds) group by org_id,user_id,signup_course_id";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgId", orgId);
        param.put("classId", classId);
        param.put("userIds", userIds);
        param.put("type", 1);
        List list = this.getNamedJdbcTemplate().query(sql, param, (RowMapper)new RowMapper<OrgSignupCourseLesson>(){

            public OrgSignupCourseLesson mapRow(ResultSet rs, int rowNum) throws SQLException {
                OrgSignupCourseLesson stat = OrgSignupCourseLessonDaoImpl.this.toOrgSignupCourseLesson(rs);
                stat.setSignupCourseId(rs.getLong("signup_course_id"));
                return stat;
            }
        });
        Map signupLessonsMap = CollectionUtils.extractMap((Collection)list, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, OrgSignupCourseLesson>(){

            public Long extract(OrgSignupCourseLesson lesson) {
                return lesson.getSignupCourseId();
            }
        });
        return signupLessonsMap;
    }

    @Override
    public Map<String, OrgSignupCourseLesson> selectLessonInfoMap(Long orgId, Collection<Long> lessonIds, Collection<Long> userIds) {
        String sql = "select org_id,lesson_id,user_id,class_id,course_id,charge_unit,sum(lesson_duration) as lesson_duration,count(*) as lesson_count,sum(amount) as amount   from yunying.tx_signup_course_lesson where org_id=:orgId and lesson_id in (:lessonIds) and user_id in (:userIds) group by org_id,lesson_id,user_id";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("lessonIds", lessonIds);
        param.put("userIds", userIds);
        param.put("orgId", orgId);
        List list = this.getNamedJdbcTemplate().query(sql, param, (RowMapper)new RowMapper<OrgSignupCourseLesson>(){

            public OrgSignupCourseLesson mapRow(ResultSet rs, int rowNum) throws SQLException {
                OrgSignupCourseLesson lesson = OrgSignupCourseLessonDaoImpl.this.toOrgSignupCourseLesson(rs);
                lesson.setLessonId(rs.getLong("lesson_id"));
                lesson.setUserId(rs.getLong("user_id"));
                lesson.setClassId(rs.getLong("class_id"));
                lesson.setCourseId(rs.getLong("course_id"));
                lesson.setChargeUnit(rs.getInt("charge_unit"));
                return lesson;
            }
        });
        Map signupLessonsMap = CollectionUtils.extractMap((Collection)list, (CollectionUtils.Extracter)new CollectionUtils.Extracter<String, OrgSignupCourseLesson>(){

            public String extract(OrgSignupCourseLesson lesson) {
                return lesson.getUserId() + "_" + lesson.getLessonId();
            }
        });
        return signupLessonsMap;
    }

    @Override
    public Map<Long, OrgSignupCourseLesson> selectLessonInfoByClassId(Long orgId, Long classId, Collection<Long> userIds, Integer lessonType) {
        String sql = "select org_id,user_id,class_id,course_id,charge_unit,sum(lesson_duration) as lesson_duration,count(*) as lesson_count,sum(amount) as amount from yunying.tx_signup_course_lesson where org_id=:orgId and class_id=:classId and user_id in (:userIds) ";
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (lessonType != null) {
            sql = sql + " and lesson_type=:lessonType";
            param.put("lessonType", lessonType);
        }
        sql = sql + " group by org_id,class_id,user_id";
        param.put("classId", classId);
        param.put("userIds", userIds);
        param.put("orgId", orgId);
        List list = this.getNamedJdbcTemplate().query(sql, param, (RowMapper)new RowMapper<OrgSignupCourseLesson>(){

            public OrgSignupCourseLesson mapRow(ResultSet rs, int rowNum) throws SQLException {
                OrgSignupCourseLesson lesson = OrgSignupCourseLessonDaoImpl.this.toOrgSignupCourseLesson(rs);
                lesson.setUserId(rs.getLong("user_id"));
                lesson.setClassId(rs.getLong("class_id"));
                lesson.setCourseId(rs.getLong("course_id"));
                lesson.setChargeUnit(rs.getInt("charge_unit"));
                return lesson;
            }
        });
        Map signupLessonsMap = CollectionUtils.extractMap((Collection)list, (CollectionUtils.Extracter)new CollectionUtils.Extracter<Long, OrgSignupCourseLesson>(){

            public Long extract(OrgSignupCourseLesson lesson) {
                return lesson.getUserId();
            }
        });
        return signupLessonsMap;
    }

    private OrgSignupCourseLesson toOrgSignupCourseLesson(ResultSet rs) throws SQLException {
        OrgSignupCourseLesson stat = new OrgSignupCourseLesson();
        stat.setOrgId(rs.getLong("org_id"));
        stat.setLessonCount(rs.getInt("lesson_count"));
        stat.setLessonDuration(rs.getInt("lesson_duration"));
        stat.setAmount(rs.getLong("amount"));
        return stat;
    }

    @Override
    public void batchDelLesson(long orgId, Collection<Long> lessonIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("lessonId", lessonIds);
        param.put("orgId", orgId);
        this.delByCondition(param);
    }

    @Override
    public void batchDelStuLesson(long orgId, Collection<Long> userIds, Collection<Long> lessonIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        if (userIds != null && !userIds.isEmpty()) {
            param.put("userId", userIds);
        }
        param.put("orgId", orgId);
        param.put("lessonId", lessonIds);
        this.delByCondition(param);
    }

    @Override
    public void batchCancelLesson(Long orgId, Long lessonId, Collection<Long> userIds) {
        if (org.apache.commons.collections4.CollectionUtils.isEmpty(userIds)) {
            return;
        }
        String sql = "update yunying.tx_signup_course_lesson set lesson_type=3,signup_course_id=-1 where user_id in (:userIds) and lesson_id = :lessonId and org_id=:orgId and lesson_type=1";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgId", orgId);
        param.put("lessonId", lessonId);
        param.put("userIds", userIds);
        this.getNamedJdbcTemplate().update(sql, param);
    }

    @Override
    public void batchUpdateLessonDuration(Long orgId, Long lessonId, Collection<Long> userIds, long lessonDuration) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgId", orgId);
        param.put("lessonId", lessonId);
        param.put("userId", userIds);
        param.put("lessonDuration", lessonDuration);
        param.put("lessonType", 2);
        this.update(param, new String[]{"lessonDuration"});
    }

    @Override
    public List<OrgSignupCourseLesson> getLessonList(Long orgId, Collection<Long> lessonIds, Collection<Long> userIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.in("lessonId", lessonIds);
        builder.in("userId", userIds);
        return this.queryList(builder);
    }
}

