/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.signup.dao.impl;

import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.constant.SignupSupplementType;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dto.OrgStudentSignupStatistics;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class OrgSignupCourseDaoImpl
extends JdbcTemplateDaoSupport<OrgSignupCourse>
implements OrgSignupCourseDao {
    private static final Logger log = LoggerFactory.getLogger(OrgSignupCourseDaoImpl.class);
    private static final String syncUpdateSql = "update yunying.org_signup_course set class_id = :classId where class_id = -1 and org_id = :orgId and user_id =:userId and org_course_id = :courseId";

    public OrgSignupCourseDaoImpl() {
        super(OrgSignupCourse.class);
    }

    @Override
    public List<Long> searchPurchaseIdByCourseId(@NonNull Collection<Long> courseIds, Date startTime, Date endTime) {
        if (courseIds == null) {
            throw new NullPointerException("courseIds");
        }
        if (CollectionUtils.isEmpty(courseIds)) {
            return Collections.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select("signupPurchaseId");
        builder.in("orgCourseId", courseIds);
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<OrgSignupCourse> loadByPurchaseIds(@NonNull Collection<Long> purchaseIds, final String ... queryProps) {
        if (purchaseIds == null) {
            throw new NullPointerException("purchaseIds");
        }
        if (CollectionUtils.isEmpty(purchaseIds)) {
            return Collections.emptyList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        return (List)queryTemplate.batchQuery(purchaseIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgSignupCourse>>(){

            public List<OrgSignupCourse> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgSignupCourseDaoImpl.this.createSqlBuilder(new String[0]);
                builder.select(queryProps);
                builder.in("signupPurchaseId", querySet);
                return OrgSignupCourseDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<OrgSignupCourse> loadByPurchaseId(@NonNull Long purchaseId, String ... queryProps) {
        if (purchaseId == null) {
            throw new NullPointerException("purchaseId");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(queryProps);
        builder.eq("signupPurchaseId", (Serializable)purchaseId);
        return this.queryList(builder);
    }

    @Override
    public void saveOrUpdateSignupCourse(@NonNull OrgSignupCourse signupCourse) {
        if (signupCourse == null) {
            throw new NullPointerException("signupCourse");
        }
        if (signupCourse.getId() > 0L) {
            this.update((Object)signupCourse, new String[0]);
        } else {
            this.save((Object)signupCourse, new String[0]);
        }
    }

    public void updateByCourseId(@NonNull OrgSignupCourse signupCourse) {
        if (signupCourse == null) {
            throw new NullPointerException("signupCourse");
        }
        HashMap updateCondition = Maps.newHashMap();
        updateCondition.put("orgCourseId", signupCourse.getOrgCourseId());
        this.update(updateCondition, (Object)signupCourse, new String[0]);
    }

    @Override
    public void saveSignupCourses(List<OrgSignupCourse> courses) {
        this.saveAll(courses, new String[0]);
    }

    @Override
    public OrgSignupCourse getByCourseId(Long orgId, Long purchaseId, Long courseId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("orgCourseId", (Serializable)courseId);
        builder.eq("signupPurchaseId", (Serializable)purchaseId);
        return (OrgSignupCourse)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<OrgSignupCourse> searchByUserIdsAndCourseId(Collection<Long> userIds, Long classId, Long orgId, Collection<Integer> status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.in("status", status);
        builder.eq("classId", (Serializable)classId);
        builder.in("userId", userIds);
        log.debug("searchByUserIdsAndCourseId sql={},params={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return this.queryList(builder);
    }

    @Override
    public List<OrgSignupCourse> getByCourseIdAndStudentId(Long orgId, Long userId, Long courseId, Collection<Integer> status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("orgCourseId", (Serializable)courseId);
        if (CollectionUtils.isNotEmpty(status)) {
            builder.in("status", status);
        }
        builder.eq("userId", (Serializable)userId);
        builder.eq("isDel", (Serializable)Integer.valueOf(DataStatus.NORMAL.getValue()));
        log.debug("getByCourseIdsAndStudentId sql={},params={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return this.queryList(builder);
    }

    @Override
    public List<OrgSignupCourse> getByCourseIdsAndStudentId(Long orgId, Long userId, Collection<Long> courseIds, Collection<Integer> status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(courseIds)) {
            builder.in("orgCourseId", courseIds);
        }
        if (CollectionUtils.isNotEmpty(status)) {
            builder.in("status", status);
        }
        builder.eq("userId", (Serializable)userId);
        builder.eq("isDel", (Serializable)Integer.valueOf(DataStatus.NORMAL.getValue()));
        log.debug("getByCourseIdsAndStudentId sql={},params={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return this.queryList(builder);
    }

    @Override
    public int updateStatusByPurchaseId(Long signupPurchaseId, Long orgCourseId, Long userId, Integer status) {
        Preconditions.checkArgument((orgCourseId != null && orgCourseId > 0L ? 1 : 0) != 0, (Object)"orgCourseId is null!");
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"userId is null!");
        StringBuilder sb = new StringBuilder("update yunying.org_signup_course set status = :status,sync_lesson_count=0,update_time=now() where 1=1 ");
        HashedMap params = new HashedMap();
        if (signupPurchaseId != null && signupPurchaseId != 0L) {
            sb.append("and signup_purchase_id = :signupPurchaseId");
            params.put("signupPurchaseId", signupPurchaseId);
        }
        sb.append(" and org_course_id = :orgCourseId and user_id = :userId and status != :status and status !=0");
        params.put("orgCourseId", orgCourseId);
        params.put("userId", userId);
        params.put("status", status);
        int result = this.getNamedJdbcTemplate().update(sb.toString(), (Map)params);
        log.debug("updateStatusByPurchaseId sql={},params={}\uff0cresult={}", new Object[]{sb.toString(), params, result});
        return result;
    }

    @Override
    public int updateStatusByPurchaseId(Long signupPurchaseId, Integer status) {
        Preconditions.checkArgument((signupPurchaseId != null && signupPurchaseId > 0L ? 1 : 0) != 0, (Object)"signupPurchaseId is null!");
        StringBuilder sb = new StringBuilder("update yunying.org_signup_course set status = :status,update_time=now() where signup_purchase_id = :signupPurchaseId and status !=:status");
        HashedMap params = new HashedMap();
        params.put("signupPurchaseId", signupPurchaseId);
        params.put("status", status);
        int result = this.getNamedJdbcTemplate().update(sb.toString(), (Map)params);
        log.debug("updateStatusByPurchaseId sql={},params={}\uff0cresult={}", new Object[]{sb.toString(), params, result});
        return result;
    }

    @Override
    public int updateLessonCountByPurchaseId(Long signupPurchaseId, Long orgCourseId) {
        Preconditions.checkArgument((signupPurchaseId != null && signupPurchaseId > 0L ? 1 : 0) != 0, (Object)"signupPurchaseId is null!");
        Preconditions.checkArgument((orgCourseId != null && orgCourseId > 0L ? 1 : 0) != 0, (Object)"orgCourseId is null!");
        StringBuilder sb = new StringBuilder("update yunying.org_signup_course set lesson_count = count,update_time=now() where signup_purchase_id = :signupPurchaseId and org_course_id =:orgCourseId and lesson_count =0 ");
        HashedMap params = new HashedMap();
        params.put("signupPurchaseId", signupPurchaseId);
        params.put("orgCourseId", orgCourseId);
        int result = this.getNamedJdbcTemplate().update(sb.toString(), (Map)params);
        log.info("updateStatusByPurchaseId sql={},params={}\uff0cresult={}", new Object[]{sb.toString(), params, result});
        return result;
    }

    @Override
    public void delSignupCourseByPurchaseId(Long signupPurchaseId) {
        Preconditions.checkArgument((signupPurchaseId != null && signupPurchaseId > 0L ? 1 : 0) != 0, (Object)"signupPurchaseId is null!");
        StringBuilder sb = new StringBuilder("update yunying.org_signup_course set status = 1,update_time=now() where signup_purchase_id = :signupPurchaseId ");
        HashedMap params = new HashedMap();
        params.put("signupPurchaseId", signupPurchaseId);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)params);
    }

    @Override
    public List<OrgSignupCourse> getByCourseIdsAndStudentIds(Collection<Long> delUserIds, Long orgId, Collection<Long> classIds, Collection<Long> userIds, Integer supplement, PageDto pageDto, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.eq("orgId", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(classIds)) {
            builder.in("classId", classIds);
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            if (CollectionUtils.isNotEmpty(delUserIds)) {
                userIds.removeAll(delUserIds);
            }
            builder.in("userId", userIds);
        } else if (CollectionUtils.isNotEmpty(delUserIds)) {
            builder.notin("userId", delUserIds);
        }
        this.setSupplement(supplement, (SingleSqlBuilder<OrgSignupCourse>)builder);
        builder.in("status", (Collection)Lists.newArrayList(SignupCourseStatus.inClassStatus));
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (null != pageDto) {
            builder.setPage(pageDto);
        }
        log.debug("sql:{}, params:{}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        List result = this.queryList(builder);
        for (OrgSignupCourse signupCourse : result) {
            signupCourse.setSupplement(supplement);
        }
        return result;
    }

    @Override
    public List<OrgSignupCourse> getByCourseIdsAndStudentIds(Collection<Long> orgIds, Collection<Long> courseIds, Collection<Long> userIds, String ... props) {
        if (CollectionUtils.isEmpty(orgIds) || CollectionUtils.isEmpty(courseIds) || CollectionUtils.isEmpty(userIds)) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.in("orgId", orgIds);
        builder.in("orgCourseId", courseIds);
        builder.in("userId", userIds);
        return this.queryList(builder);
    }

    @Override
    public List<OrgSignupCourse> getLeftQuitClassSignupCourse(Long orgId, Long orgCourseId, Long userId, Long signPurchaseId, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("orgCourseId", (Serializable)orgCourseId);
        builder.eq("userId", (Serializable)userId);
        builder.ne("signupPurchaseId", (Serializable)signPurchaseId);
        builder.in("status", SignupCourseStatus.inClassStatus);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Object> getSignupedCourseIdsByStudentId(Long orgId, Long userId) {
        Object object = new Object();
        HashMap result = Maps.newHashMap();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"orgCourseId"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        builder.eq("isDel", (Serializable)Integer.valueOf(DataStatus.NORMAL.getValue()));
        List list = this.queryForList(builder, Long.class);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        for (Long l : list) {
            result.put(l, object);
        }
        return result;
    }

    @Override
    public Map<Long, Object> getSignupedUserIdsByCourseId(Long orgId, Long courseId) {
        Object object = new Object();
        HashMap result = Maps.newHashMap();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("orgCourseId", (Serializable)courseId);
        builder.eq("isDel", (Serializable)Integer.valueOf(DataStatus.NORMAL.getValue()));
        builder.in("status", SignupCourseStatus.inClassStatus);
        List list = this.queryForList(builder, Long.class);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        for (Long l : list) {
            result.put(l, object);
        }
        return result;
    }

    @Override
    public List<OrgSignupCourse> getByCourseIdsAndStudentIds(Long orgId, Collection<Integer> ids, Collection<Long> courseIds, Collection<Long> userIds, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        if (CollectionUtils.isNotEmpty(ids)) {
            builder.in("id", ids);
        }
        builder.eq("orgId", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(courseIds)) {
            builder.in("orgCourseId", courseIds);
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.in("userId", userIds);
        }
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> getCourseStudentCountMap(Collection<Long> delUserIds, Long orgId, List<Long> classId, Integer supplement) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"classId"});
        builder.eq("orgId", (Serializable)orgId);
        if (CollectionUtils.isEmpty(classId)) {
            return Maps.newHashMap();
        }
        builder.in("classId", classId);
        if (CollectionUtils.isNotEmpty(delUserIds)) {
            builder.notin("userId", delUserIds);
        }
        this.setSupplement(supplement, (SingleSqlBuilder<OrgSignupCourse>)builder);
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.in("status", (Collection)Lists.newArrayList(SignupCourseStatus.inClassStatus));
        builder.count("id", "count");
        builder.groupByNames(new String[]{"classId"});
        return CollectorUtil.collectMap((Collection)this.queryList(builder), (Function)new Function<OrgSignupCourse, Long>(){

            public Long apply(OrgSignupCourse input) {
                return input.getClassId();
            }
        }, (Function)new Function<OrgSignupCourse, Integer>(){

            public Integer apply(OrgSignupCourse input) {
                return input.getCount();
            }
        });
    }

    @Override
    public Map<Long, Boolean> canShowTotalCount(Long orgId, Collection<Long> userIds, Collection<Long> courseIds) {
        if (GenericsUtils.isNullOrEmpty(userIds)) {
            return GenericsUtils.emptyMap();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("orgId", (Serializable)orgId);
        builder.in("userId", userIds);
        if (GenericsUtils.notNullAndEmpty(courseIds)) {
            builder.in("orgCourseId", courseIds);
        }
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.gt("chargeUnit", (Serializable)Integer.valueOf(-1));
        builder.count("id", "sqlCount");
        builder.groupByNames(new String[]{"userId", "orgCourseId"});
        List queryList = this.queryList(builder);
        queryList = GenericsUtils.isNullOrEmpty((Object)queryList) ? GenericsUtils.emptyList() : queryList;
        Map orgSignupCourseMap = GenericsUtils.toFieldMap((Collection)queryList, (String[])new String[]{"userId"});
        HashMap retMap = Maps.newHashMap();
        Iterator<Long> iterator = userIds.iterator();
        while (iterator.hasNext()) {
            Long userId;
            OrgSignupCourse list = (OrgSignupCourse)((Object)orgSignupCourseMap.get(userId = iterator.next()));
            retMap.put(userId, list != null && list.getSqlCount() != null && list.getSqlCount() > 0);
        }
        return retMap;
    }

    @Override
    public List<OrgStudentSignupStatistics> findAllOrgStudentSignupStatistics(Long orgId, Collection<Long> userIds, Collection<Long> courseIds) {
        log.info("userIds are :{} ", userIds);
        if (GenericsUtils.isNullOrEmpty(userIds)) {
            return GenericsUtils.emptyList();
        }
        String courseIdsCondition = "";
        HashMap paramMap = Maps.newHashMap();
        if (GenericsUtils.notNullAndEmpty(courseIds)) {
            courseIdsCondition = " and org_course_id in(:orgCourseIds) ";
            paramMap.put("orgCourseIds", courseIds);
        }
        String sql = "select user_id as userId,org_course_id as courseId,  sum(if(status in(2,3,4,5,6),lesson_count,0)) as buyCount, sum(if(status in(2,3,4,5,6),pay_price + student_pay_price,0)) as payMoney,count(if(lesson_count=0,1,null)) as chargeUnitStatus  from yunying.org_signup_course where status in(:status) and org_Id=:orgId and user_id in(:userIds) " + courseIdsCondition + " and is_del=:isDel  group by user_id,org_course_id  ";
        paramMap.put("userIds", userIds);
        paramMap.put("orgId", orgId);
        paramMap.put("isDel", DeleteStatus.NORMAL.getValue());
        paramMap.put("status", Arrays.asList(SignupCourseStatus.HAS_PAY.getCode(), SignupCourseStatus.INIT.getCode(), SignupCourseStatus.IMPORT.getCode(), SignupCourseStatus.HAS_ADD.getCode(), SignupCourseStatus.QUIT_PURCHASE.getCode(), SignupCourseStatus.QUIT_CLASS.getCode()));
        log.info("sql is :{} and paramMap is :{} ", (Object)sql, (Object)paramMap);
        final ArrayList queryForList = Lists.newArrayList();
        try {
            this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (ResultSetExtractor)new ResultSetExtractor<OrgStudentSignupStatistics>(){

                public OrgStudentSignupStatistics extractData(ResultSet rs) throws SQLException, DataAccessException {
                    while (rs.next()) {
                        OrgStudentSignupStatistics os = this.createOrgStudentSignupStatistics(rs);
                        if (os == null) continue;
                        queryForList.add(os);
                    }
                    return null;
                }

                private OrgStudentSignupStatistics createOrgStudentSignupStatistics(ResultSet rs) {
                    OrgStudentSignupStatistics os = null;
                    try {
                        os = new OrgStudentSignupStatistics();
                        os.setPayMoney(rs.getLong("payMoney"));
                        os.setCourseId(rs.getLong("courseId"));
                        os.setUserId(rs.getLong("userId"));
                        os.setChargeUnitStatus(rs.getLong("chargeUnitStatus"));
                    }
                    catch (SQLException e) {
                        log.error("exception is :{} ", (Throwable)e);
                    }
                    return os;
                }
            });
        }
        catch (Exception e) {
            log.error("exception :{} ", (Throwable)e);
        }
        return queryForList;
    }

    @Override
    public Map<Long, OrgSignupCourse> mapKeyClassId(Long orgId, Long userId) {
        HashMap<Long, OrgSignupCourse> result = new HashMap<Long, OrgSignupCourse>();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        builder.gt("classId", (Serializable)Integer.valueOf(-1));
        List list = this.queryList(builder);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OrgSignupCourse obj : list) {
                result.put(obj.getClassId(), obj);
            }
        }
        return result;
    }

    @Override
    public Map<Long, OrgSignupCourse> mapKeyUserId(Long orgId, Long classId) {
        HashMap<Long, OrgSignupCourse> result = new HashMap<Long, OrgSignupCourse>();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("classId", (Serializable)classId);
        List list = this.queryList(builder);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OrgSignupCourse obj : list) {
                result.put(obj.getUserId(), obj);
            }
        }
        return result;
    }

    @Override
    public List<OrgSignupCourse> listByUserId(Long orgId, Collection<Long> classIds, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.gt("classId", (Serializable)Integer.valueOf(-1));
        if (classIds != null) {
            builder.in("classId", classIds);
        }
        if (userId != null) {
            builder.eq("userId", (Serializable)userId);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgSignupCourse> listByClassId(Long orgId, Long classId, Collection<Long> userIds, List<Integer> status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.gt("classId", (Serializable)Integer.valueOf(-1));
        if (classId != null) {
            builder.eq("classId", (Serializable)classId);
        }
        if (userIds != null) {
            builder.in("userId", userIds);
        }
        if (CollectionUtils.isNotEmpty(status)) {
            builder.in("status", status);
        }
        return this.queryList(builder);
    }

    @Override
    public List<Long> getClassIds(Collection<Long> delUserIds, Collection<Long> notInCourseIds, Long orgId, Collection<Long> courseNameClassIds, Integer supplement, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"classId"});
        builder.eq("orgId", (Serializable)orgId);
        if (CollectionUtils.isNotEmpty(courseNameClassIds)) {
            courseNameClassIds.removeAll(notInCourseIds);
            builder.in("classId", courseNameClassIds);
        } else if (CollectionUtils.isNotEmpty(notInCourseIds)) {
            builder.notin("classId", notInCourseIds);
        }
        if (CollectionUtils.isNotEmpty(delUserIds)) {
            builder.notin("userId", delUserIds);
        }
        this.setSupplement(supplement, (SingleSqlBuilder<OrgSignupCourse>)builder);
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.in("status", (Collection)Lists.newArrayList(SignupCourseStatus.inClassStatus));
        builder.group("classId");
        builder.desc("classId");
        Integer count = (Integer)this.getNamedJdbcTemplate().queryForObject("select count(1) from (" + builder.toSql() + ") as a", builder.collectConditionValue(), Integer.class);
        builder.setPage(pageDto);
        List result = Lists.transform((List)this.queryList(builder), (Function)new Function<OrgSignupCourse, Long>(){

            public Long apply(OrgSignupCourse input) {
                return input.getClassId();
            }
        });
        pageDto.setCount(count);
        return result;
    }

    private void setSupplement(Integer supplement, SingleSqlBuilder<OrgSignupCourse> builder) {
        if (null != supplement && SignupSupplementType.ALL.getCode() != supplement.intValue()) {
            if (supplement.intValue() == SignupSupplementType.OLD.getCode()) {
                builder.eq("lessonCount", (Serializable)Integer.valueOf(Flag.FALSE.getInt()));
                builder.eq("kexiaoCascadeId", (Serializable)Integer.valueOf(Flag.NULL.getInt()));
                builder.desc("createTime");
            } else if (supplement.intValue() == SignupSupplementType.OLD_FIXED.getCode()) {
                builder.gt("lessonCount", (Serializable)Integer.valueOf(Flag.FALSE.getInt()));
                builder.gt("kexiaoCascadeId", (Serializable)Integer.valueOf(Flag.NULL.getInt()));
                builder.desc("kexiaoTime");
            } else if (supplement.intValue() == SignupSupplementType.NEW.getCode()) {
                builder.gt("lessonCount", (Serializable)Integer.valueOf(Flag.FALSE.getInt()));
                builder.eq("kexiaoCascadeId", (Serializable)Integer.valueOf(Flag.NULL.getInt()));
                builder.desc("createTime");
            } else if (supplement.intValue() == SignupSupplementType.NOT_NEW.getCode()) {
                builder.or(Expressions.eq((String)"lessonCount", (Serializable)Integer.valueOf(Flag.FALSE.getInt())), Expressions.gt((String)"kexiaoCascadeId", (Serializable)Integer.valueOf(Flag.NULL.getInt())));
                builder.desc("createTime");
            }
        }
    }

    @Override
    public void syncRealCourseId(Collection<String> syncDatas) {
        if (GenericsUtils.isNullOrEmpty(syncDatas)) {
            return;
        }
        HashMap paramMap = Maps.newHashMap();
        for (String syncDataStr : syncDatas) {
            List stringToNumber = GenericsUtils.stringToNumberList((String)syncDataStr, (String)"_", Long.class);
            Long userId = (Long)stringToNumber.get(0);
            Long courseId = (Long)stringToNumber.get(1);
            Long orgId = (Long)stringToNumber.get(2);
            Long classId = (Long)stringToNumber.get(3);
            paramMap.put("userId", userId);
            paramMap.put("courseId", courseId);
            paramMap.put("orgId", orgId);
            paramMap.put("classId", classId);
            this.getNamedJdbcTemplate().update(syncUpdateSql, (Map)paramMap);
            log.info("update org_signup_refund with sql:{} and paramMap: {}", (Object)syncUpdateSql, (Object)paramMap);
        }
    }

    @Override
    public List<OrgSignupCourse> getCousePurchaseListByMinId(Long minId, Date lastDate, int maxSize, List<Integer> notStatus, String ... queryProps) {
        Preconditions.checkArgument((maxSize > 0 ? 1 : 0) != 0, (Object)"maxSize is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (minId == null || minId == 0L) {
            if (lastDate == null) {
                throw new IllegalArgumentException("must have minId or lastDate");
            }
            builder.gt("updateTime", (Serializable)lastDate);
        } else {
            builder.gt("id", (Serializable)minId);
        }
        builder.in("status", notStatus);
        builder.le("updateTime", (Serializable)DateUtil.getDiffDateTime((Date)new Date(), (int)-5, (int)12));
        builder.desc("updateTime");
        builder.setMaxSize(Integer.valueOf(maxSize));
        return this.queryList(builder);
    }

    @Override
    public int sumAllLessonCount(Long orgId, Long orgCourseId, Long userId, List<Integer> status, String ... queryProps) {
        Preconditions.checkArgument((orgCourseId != null && userId != 0L ? 1 : 0) != 0, (Object)"orgCourseId userId is null!");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.sum("lessonCount");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("orgCourseId", (Serializable)orgCourseId);
        builder.eq("userId", (Serializable)userId);
        builder.in("status", status);
        builder.eq("isDel", (Serializable)Integer.valueOf(DataStatus.NORMAL.getValue()));
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        return count == null ? 0 : count;
    }

    @Override
    public int getSignupCourseCount(Long orgId, Long courseId, Collection<Integer> statusArr) {
        Integer count;
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("orgCourseId", (Serializable)courseId);
        builder.eq("isDel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (CollectionUtils.isNotEmpty(statusArr)) {
            builder.in("status", statusArr);
        }
        return (count = (Integer)this.queryForObject(builder, Integer.class)) == null ? 0 : count;
    }
}

