/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.roster.dao.impl;

import com.baijia.tianxiao.dal.roster.dao.CustomFieldValueDao;
import com.baijia.tianxiao.dal.roster.po.CustomFieldValue;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.map.HashedMap;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

@Repository
public class CustomFieldValueDaoImpl
extends JdbcTemplateDaoSupport<CustomFieldValue>
implements CustomFieldValueDao {
    @Override
    public List<CustomFieldValue> searchValuesByConfig(Long orgId, boolean isStudent, Long studentIdOrConsultId, List<Long> customFieldIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (isStudent) {
            builder.eq("studentId", (Serializable)studentIdOrConsultId);
        } else {
            builder.eq("consultUserId", (Serializable)studentIdOrConsultId);
        }
        if (customFieldIds != null) {
            builder.in("fieldId", customFieldIds);
        }
        return this.queryList(builder);
    }

    @Override
    public CustomFieldValue getCustomFieldValue(Long fieldId, boolean isStudent, Long studentIdOrConsultId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        if (studentIdOrConsultId != null) {
            if (isStudent) {
                builder.eq("studentId", (Serializable)studentIdOrConsultId);
            } else {
                builder.eq("consultUserId", (Serializable)studentIdOrConsultId);
            }
        }
        builder.eq("fieldId", (Serializable)fieldId);
        List list = this.queryList(builder);
        if (list != null && list.size() > 0) {
            return (CustomFieldValue)list.get(0);
        }
        return null;
    }

    @Override
    public void updateStudentId(Long orgId, Long consultId, Long studentId) {
        String sql = "UPDATE yunying.tx_custom_field_value SET student_id=:studentId WHERE consult_user_id=:consultId AND org_id=:orgId";
        HashedMap params = new HashedMap();
        params.put("studentId", studentId);
        params.put("consultId", consultId);
        params.put("orgId", orgId);
        this.getNamedJdbcTemplate().update(sql, (Map)params);
    }

    @Override
    public Map<Long, List<CustomFieldValue>> batchGetValueMap(Long orgId, final boolean isStudent, Collection<Long> coll, Collection<Long> customFieldIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(coll), (Object)"coll can not be empty");
        Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(customFieldIds), (Object)"customFieldIds can not be empty");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (isStudent) {
            builder.in("studentId", coll);
        } else {
            builder.in("consultUserId", coll);
        }
        builder.in("fieldId", customFieldIds);
        final HashMap<Long, List<CustomFieldValue>> map = new HashMap<Long, List<CustomFieldValue>>();
        this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                CustomFieldValue po = new CustomFieldValue();
                po.setId(rs.getLong("id"));
                po.setFieldId(rs.getLong("fieldId"));
                po.setOrgId(rs.getLong("orgId"));
                po.setConsultUserId(rs.getLong("consultUserId"));
                po.setStudentId(rs.getLong("studentId"));
                po.setValue(rs.getString("value"));
                po.setFieldType(rs.getInt("fieldType"));
                po.setCreateTime(rs.getDate("createTime"));
                po.setUpdateTime(rs.getDate("updateTime"));
                Long userId = null;
                ArrayList<CustomFieldValue> list = null;
                userId = isStudent ? po.getStudentId() : po.getConsultUserId();
                list = (ArrayList<CustomFieldValue>)map.get(userId);
                if (list == null) {
                    list = new ArrayList<CustomFieldValue>();
                    map.put(userId, list);
                }
                list.add(po);
            }
        });
        return map;
    }
}

