/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.push.constant;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public enum MessageSource {
    INPUT(0, "\u95e8\u5e97\u5230\u8bbf", true, true),
    TELEPHONE(1, "400\u7535\u8bdd", true, true),
    WECHAT(2, "\u5fae\u4fe1\u54a8\u8be2", true, true),
    APPOINTMENT(3, "\u9884\u7ea6\u7559\u5355", true, true),
    ONLINE_IM(4, "\u5728\u7ebf\u54a8\u8be2", true, false),
    MARKING(5, "\u63a8\u5e7f\u6d88\u606f", false, false),
    SIGNUP(6, "\u53d1\u6d3b\u52a8", true, true),
    WEI_OFFICIAL(8, "\u5fae\u5b98\u7f51", false, false),
    STAFF_INFO(9, "\u540c\u4e8b\u6d88\u606f", false, false),
    IMPORT(10, "\u7ebf\u7d22\u5bfc\u5165", true, false),
    NOTICE(100, "\u901a\u77e5", false, false),
    VZHIBO(11, "\u5fae\u76f4\u64ad", true, true);

    private int value;
    private String desc;
    private boolean isConsultSource;
    private boolean inSourceSelection;
    private static Map<Integer, MessageSource> mapping;

    public static String getDesc(Integer code) {
        if (mapping.get(code) == null) {
            return null;
        }
        return mapping.get(code).getDesc();
    }

    public static MessageSource getByType(Integer code) {
        return mapping.get(code);
    }

    private MessageSource(int value, String desc, boolean isConsultSource, boolean inSourceSelection) {
        this.value = value;
        this.desc = desc;
        this.isConsultSource = isConsultSource;
        this.inSourceSelection = inSourceSelection;
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isConsultSource() {
        return this.isConsultSource;
    }

    public String buildConsultTypeMsg(String msg) {
        String fmt = "%s$%s";
        return String.format(fmt, this.getValue(), msg);
    }

    public static List<MessageSource> listConsultSource(Boolean sourceSelection) {
        ArrayList<MessageSource> list = new ArrayList<MessageSource>();
        for (MessageSource obj : MessageSource.values()) {
            if (!obj.isConsultSource) continue;
            if (sourceSelection != null) {
                if (!sourceSelection.booleanValue() || !obj.inSourceSelection) continue;
                list.add(obj);
                continue;
            }
            list.add(obj);
        }
        return list;
    }

    public static String getText(MessageSource source) {
        switch (source) {
            case TELEPHONE: {
                return "400";
            }
            case WECHAT: {
                return "\u5fae\u4fe1";
            }
            case WEI_OFFICIAL: {
                return "\u5fae\u5b98\u7f51";
            }
            case APPOINTMENT: {
                return "\u7559\u5355";
            }
            case SIGNUP: {
                return "\u6d3b\u52a8";
            }
        }
        return null;
    }

    static {
        mapping = Maps.newHashMap();
        for (MessageSource ct : MessageSource.values()) {
            mapping.put(ct.value, ct);
        }
    }
}

