/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.TXCascadeAccountStatus;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;

@Repository
public class TxCascadeAccountDaoImpl
extends JdbcTemplateDaoSupport<TXCascadeAccount>
implements TXCascadeAccountDao {
    private static final Logger log = LoggerFactory.getLogger(TxCascadeAccountDaoImpl.class);

    public TxCascadeAccountDaoImpl() {
        super(TXCascadeAccount.class);
    }

    @Override
    public Integer getCountByOrgId(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public TXCascadeAccount getByIdAndOrgId(Integer id, Integer orgId, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("id", (Serializable)id);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("status", (Serializable)TXCascadeAccountStatus.VALID.getCode());
        return (TXCascadeAccount)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<TXCascadeAccount> getByOrgIds(List<Integer> orgIds, PageDto pageDto) {
        String sql = "select id,credential_id,account_type,org_id,title,status,isdel,update_time,create_time from yunying.tx_cascade_account where org_id in ( :orgIds ) and isdel=0 order by create_time desc ";
        HashMap paramMap = Maps.newHashMap();
        if (!CollectionUtils.isNotEmpty(orgIds)) {
            return Lists.newArrayList();
        }
        paramMap.put("orgIds", orgIds);
        if (null != pageDto) {
            Integer pageSize = pageDto.getPageSize();
            Integer curPageCount = pageDto.getCurPageCount();
            Integer pageNum = pageDto.getPageNum();
            if (null != pageSize) {
                sql = sql + " limit :pageSize ";
                paramMap.put("pageSize", pageSize);
            }
            if (null != curPageCount) {
                sql = sql + " offset :curPageCount ";
                paramMap.put("curPageCount", curPageCount);
            } else if (null != pageNum) {
                sql = sql + " offset :offSet ";
                paramMap.put("offSet", (pageNum - 1) * pageSize);
            }
        }
        log.info("getByOrgIds input param is orgIds:{},pageDto:{},sql:{}", new Object[]{orgIds, pageDto, sql});
        List accounts = this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (RowMapper)new RowMapper<TXCascadeAccount>(){

            public TXCascadeAccount mapRow(ResultSet rs, int rowNum) throws SQLException {
                TXCascadeAccount txa = new TXCascadeAccount();
                txa.setId(rs.getInt("id"));
                txa.setCredentialId(rs.getInt("credential_id"));
                txa.setAccountType(rs.getInt("account_type"));
                txa.setOrgId(rs.getInt("org_id"));
                txa.setTitle(rs.getString("title"));
                txa.setStatus(rs.getInt("status"));
                txa.setIsdel(rs.getInt("isdel"));
                txa.setUpdateTime(rs.getDate("update_time"));
                txa.setCreateTime(rs.getDate("create_time"));
                return txa;
            }
        });
        if (null != pageDto) {
            pageDto.setCurPageCount(Integer.valueOf(accounts.size()));
        }
        log.debug("the length of txCascadeAccount result is:{}", (Object)accounts.size());
        return accounts;
    }

    @Override
    public Integer getCountByOrgIds(List<Integer> orgIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.in("orgId", orgIds);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("status", (Serializable)TXCascadeAccountStatus.VALID.getCode());
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Integer getCountByOrgIds(List<Integer> orgIds, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.in("orgId", orgIds);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<TXCascadeAccount> getByCIdAndOrgId(Integer orgId, Integer credentialId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("credentialId", (Serializable)credentialId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<TXCascadeAccount> getTXCascadeAccountListByOrgId(Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("status", (Serializable)TXCascadeAccountStatus.VALID.getCode());
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<Integer> listIdByAccountType(Integer orgId, Integer accountType) {
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT id FROM yunying.tx_cascade_account WHERE isdel=0");
        if (orgId != null) {
            builder.append(" AND org_id=").append(orgId);
        }
        if (accountType != null) {
            builder.append(" AND account_type=").append(accountType);
        }
        return (List)this.getNamedJdbcTemplate().query(builder.toString(), (ResultSetExtractor)new ResultSetExtractor<List<Integer>>(){

            public List<Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<Integer> appIds = new ArrayList<Integer>();
                while (rs.next()) {
                    Integer appId = rs.getInt("id");
                    appIds.add(appId);
                }
                return appIds;
            }
        });
    }

    @Override
    public TXCascadeAccount getByCredentialIdAndOrgId(Integer orgId, Integer credentialId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("credentialId", (Serializable)credentialId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("status", (Serializable)TXCascadeAccountStatus.VALID.getCode());
        List list = this.queryList(builder);
        if (list != null && list.size() > 0) {
            return (TXCascadeAccount)((Object)list.get(0));
        }
        return null;
    }

    @Override
    public List<TXCascadeAccount> getTXCascadeAccountListByOrgId(Long orgId, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return this.queryList(builder);
    }

    @Override
    public List<TXCascadeAccount> getTXCascadeAccountListByStatusAndOrgId(Integer cascadeId, int status, Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (GenericsUtils.notNullAndEmpty((Object)cascadeId)) {
            builder.ne("id", (Serializable)cascadeId);
        }
        builder.eq("status", (Serializable)Integer.valueOf(status));
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<TXCascadeAccount> getTXCascadeAccountListByOrgIds(Collection<Integer> orgIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("orgId", orgIds);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<TXCascadeAccount> getByCredentialId(Integer credentialId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("credentialId", (Serializable)credentialId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<TXCascadeAccount> listIdByOrgId(Long orgId, Integer cascadeId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (cascadeId != null) {
            builder.ne("credentialId", (Serializable)cascadeId);
        }
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("status", (Serializable)TXCascadeAccountStatus.VALID.getCode());
        return this.queryList(builder);
    }

    @Override
    public List<TXCascadeAccount> getValidAccountsByCredentialId(Integer credentialId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("credentialId", (Serializable)credentialId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("status", (Serializable)TXCascadeAccountStatus.VALID.getCode());
        return this.queryList(builder);
    }

    @Override
    public List<TXCascadeAccount> getAllByPageDto(PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public void incrVersionByOrgId(int orgId) {
        String sql = "update yunying.tx_cascade_account set account_version=account_version+1, update_time=:updateTime where org_id=:orgId";
        HashMap<String, Comparable<Integer>> param = new HashMap<String, Comparable<Integer>>();
        param.put("orgId", Integer.valueOf(orgId));
        param.put("updateTime", new Date());
        this.getNamedJdbcTemplate().update(sql, param);
    }

    @Override
    public void incrVersionByCredentialId(int credentialId) {
        String sql = "update yunying.tx_cascade_account set account_version=account_version+1, update_time=:updateTime where credential_id=:credentialId";
        HashMap<String, Comparable<Integer>> param = new HashMap<String, Comparable<Integer>>();
        param.put("credentialId", Integer.valueOf(credentialId));
        param.put("updateTime", new Date());
        this.getNamedJdbcTemplate().update(sql, param);
    }

    @Override
    public void deleteById(int cascadeId) {
        String sql = "update yunying.tx_cascade_account set isdel=1, account_version=account_version+1, update_time=:updateTime where id=:cascadeId";
        HashMap<String, Comparable<Integer>> param = new HashMap<String, Comparable<Integer>>();
        param.put("cascadeId", Integer.valueOf(cascadeId));
        param.put("updateTime", new Date());
        this.getNamedJdbcTemplate().update(sql, param);
    }

    @Override
    public void deleteByOrgId(int orgId) {
        String sql = "update yunying.tx_cascade_account set isdel=1, account_version=account_version+1, update_time=:updateTime where org_id=:orgId";
        HashMap<String, Comparable<Integer>> param = new HashMap<String, Comparable<Integer>>();
        param.put("orgId", Integer.valueOf(orgId));
        param.put("updateTime", new Date());
        this.getNamedJdbcTemplate().update(sql, param);
    }
}

