/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.TXAccountStatus;
import com.baijia.tianxiao.dal.org.dao.TXAccountDao;
import com.baijia.tianxiao.dal.org.po.TXAccount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class TXAccountDaoImpl
extends JdbcTemplateDaoSupport<TXAccount>
implements TXAccountDao {
    private static final Logger log = LoggerFactory.getLogger(TXAccountDaoImpl.class);

    public TXAccountDaoImpl() {
        super(TXAccount.class);
    }

    @Override
    public TXAccount getByOrgId(Integer orgId, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (null != status) {
            builder.eq("status", (Serializable)status);
        }
        return (TXAccount)this.uniqueResult(builder);
    }

    @Override
    public TXAccount getByIdAndOrgId(Integer id, Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("id", (Serializable)id);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("status", (Serializable)TXAccountStatus.VALID.getCode());
        return (TXAccount)this.uniqueResult(builder);
    }

    @Override
    public TXAccount getByOrgNumber(Integer orgNumber) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgNumber", (Serializable)orgNumber);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (TXAccount)this.uniqueResult(builder);
    }

    @Override
    public Map<Long, TXAccount> getAccountTypeMap(Collection<Long> orgIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("orgId", orgIds);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("status", (Serializable)TXAccountStatus.VALID.getCode());
        List txAccontList = this.queryList(builder);
        HashMap<Long, TXAccount> txAccountMap = new HashMap<Long, TXAccount>();
        if (txAccontList != null && txAccontList.size() > 0) {
            for (TXAccount txAccount : txAccontList) {
                txAccountMap.put(txAccount.getOrgId().longValue(), txAccount);
            }
        }
        return txAccountMap;
    }

    @Override
    public void findAndUpdateInfoFillStatus(Integer orgId) {
        TXAccount tXAccount = this.findTxAccountForUpdate(orgId, 0);
        if (tXAccount != null) {
            tXAccount.setInfoFillStatus(1);
            this.update(tXAccount, new String[]{"infoFillStatus"});
        }
    }

    @Override
    public TXAccount saveOrUpdateStartUpPageInfo(Integer orgId, String initOrgName, String orgSlogan, String orgLogo) {
        TXAccount tXAccount = this.findTxAccountForUpdate(orgId, new Integer[0]);
        log.info("tXAccount ======== is :{} ", (Object)tXAccount);
        if (tXAccount != null) {
            tXAccount.setOrgSlogan(orgSlogan);
            tXAccount.setOrgLogo(orgLogo);
            tXAccount.setInitOrgName(initOrgName);
            tXAccount.setInfoFillStatus(2);
            this.update(tXAccount, new String[]{"infoFillStatus", "initOrgName", "orgSlogan", "orgLogo"});
        }
        return tXAccount;
    }

    private TXAccount findTxAccountForUpdate(Integer orgId, Integer ... infoFillStatus) {
        String sql = "select info_fill_status as infoFillStatus ,id  from yunying.tx_account where org_id =:orgId and info_fill_status in(:status) for update";
        HashMap paramMap = Maps.newHashMap();
        if (GenericsUtils.isNullOrEmpty((Object)infoFillStatus)) {
            infoFillStatus = new Integer[]{0, 1, 2};
        }
        paramMap.put("orgId", orgId);
        paramMap.put("status", Arrays.asList(infoFillStatus));
        final ArrayList tXAccounts = Lists.newArrayList();
        log.info("paramMap is :{} ", (Object)paramMap);
        this.getNamedJdbcTemplate().query(sql, (Map)paramMap, (ResultSetExtractor)new ResultSetExtractor<TXAccount>(){

            public TXAccount extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    log.info("rs is :{} ", (Object)rs);
                    TXAccount tx = new TXAccount();
                    tx.setId(rs.getInt("id"));
                    tx.setInfoFillStatus(rs.getInt("infoFillStatus"));
                    tXAccounts.add(tx);
                }
                return null;
            }
        });
        log.info("************tXAccounts is :{} ", (Object)tXAccounts);
        if (GenericsUtils.isNullOrEmpty((Object)tXAccounts)) {
            return null;
        }
        return (TXAccount)tXAccounts.get(0);
    }
}

