/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.constant.OrgTeacherStatus;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.stereotype.Repository;

@Repository
public class OrgTeacherDaoImpl
extends JdbcTemplateDaoSupport<OrgTeacher>
implements OrgTeacherDao {
    private static final Logger log = LoggerFactory.getLogger(OrgTeacherDaoImpl.class);

    public OrgTeacherDaoImpl() {
        super(OrgTeacher.class);
    }

    @Override
    public List<Long> getTeacherIds(Long orgId, Integer status) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        return this.queryForList(builder, Long.class);
    }

    @Override
    public List<OrgTeacher> listByLastId(Long orgId, Long lastId, Integer pageSize, Integer status, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        if (lastId != null & lastId != 0L) {
            builder.lt("id", (Serializable)lastId);
        }
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        builder.setMaxSize(pageSize);
        builder.desc("id");
        log.debug("list by last id sql = {},params = {}", (Object)builder.toSql(), (Object)builder);
        return this.queryList(builder);
    }

    @Override
    public List<OrgTeacher> getTeacherByOpenIdAndOrgId(Long orgId, String weixinOpenId, Integer status, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("weixin", (Serializable)((Object)weixinOpenId));
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        builder.desc("id");
        return this.queryList(builder);
    }

    @Override
    public List<OrgTeacher> getTeacherByMobileAndOrgId(Long orgId, String mobile, Integer maxSize, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile}), (Object)"mobile can not be empty!");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("status", (Serializable)Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()));
        builder.desc("id");
        if (maxSize != null && maxSize > 0) {
            builder.setMaxSize(maxSize);
        }
        log.debug("sql={},param={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return this.queryList(builder);
    }

    @Override
    public List<OrgTeacher> getTeacherByUserIdAndOrgId(Long orgId, Long userId, Integer status, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("userId", (Serializable)userId);
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        builder.desc("id");
        return this.queryList(builder);
    }

    @Override
    public List<OrgTeacher> getTeacherByUserIdsAndOrgId(Long orgId, Collection<Long> userIds, Integer status, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.in("userId", userIds);
        builder.eq("orgId", (Serializable)orgId);
        if (status != null) {
            builder.eq("status", (Serializable)status);
        }
        builder.desc("id");
        return this.queryList(builder);
    }

    @Override
    public Map<Long, OrgTeacher> getMapByIds(Long orgId, Collection<Long> userIds, String ... queryProps) {
        if (userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        List<OrgTeacher> orgTeachers = this.getTeacherByUserIdsAndOrgId(orgId, userIds, OrgTeacherStatus.SIGNED.getCode(), queryProps);
        if (CollectionUtils.isEmpty(orgTeachers)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (OrgTeacher user : orgTeachers) {
            result.put(Long.valueOf(user.getUserId()), user);
        }
        return result;
    }

    @Override
    public void refreshOrgTeacher(Long orgId, Long id) {
        StringBuilder sb = new StringBuilder("update yunying.org_teachers set status =2,fire_time=now() where id > :id and  org_id = :orgId");
        HashMap param = Maps.newHashMap();
        param.put("orgId", orgId);
        param.put("id", id);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
    }

    @Override
    public void saveCdbOrgTeacher(Long userId, Long userNumber, Long orgId) {
        StringBuilder sb = new StringBuilder("insert into cdb.org_teacher(user_id,user_number,is_valid,created_at,org_id) values(:userId,:userNumber,1,now(),:orgId)");
        HashMap param = Maps.newHashMap();
        param.put("orgId", orgId);
        param.put("userId", userId);
        param.put("userNumber", userNumber);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
    }

    @Override
    public List<OrgTeacher> getTeachersByOrgId(Long orgId, PageDto page, String ... queryProp) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(queryProp);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("status", (Serializable)Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()));
        builder.desc("id");
        builder.setPage(page);
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> getTeacherTotalMapByOrgIds(Date startDate, Date endDate, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select count(1) as count, org_id from yunying.org_teachers where org_id in (:orgIds) and status = 1 ";
        if (startDate != null && endDate != null) {
            sql = sql + " and create_time between :startDate and :endDate";
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        sql = sql + " GROUP BY org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }

    @Override
    public List<OrgTeacher> getOrgTeacherListByOrgIds(List<Long> orgIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("orgId", orgIds);
        builder.eq("status", (Serializable)Integer.valueOf(1));
        return this.queryList(builder);
    }

    @Override
    public Integer getSignedTeacherCount(List<Long> orgIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.in("orgId", orgIds);
        builder.eq("status", (Serializable)Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()));
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Map<Integer, Integer> getSignedTeacherCountMap(List<Integer> orgIds) {
        final HashMap data = Maps.newHashMap();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id", "num");
        builder.in("orgId", orgIds);
        builder.group("orgId");
        builder.eq("status", (Serializable)Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()));
        this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                data.put(rs.getInt("orgId"), rs.getInt("num"));
            }
        });
        return data;
    }

    @Override
    public OrgTeacher getTeachersByOrgIdAndId(Long orgId, Long teacherId, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("status", (Serializable)Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()));
        builder.eq("user_id", (Serializable)teacherId);
        builder.desc("id");
        builder.setPage(pageDto);
        return (OrgTeacher)((Object)this.queryForObject(builder, OrgTeacher.class));
    }

    @Override
    public OrgTeacher getTeachersByUserId(Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("status", (Serializable)Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()));
        builder.eq("user_id", (Serializable)userId);
        log.debug("---------------sql = {},param={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return (OrgTeacher)((Object)this.uniqueResult(builder, OrgTeacher.class));
    }

    @Override
    public List<OrgTeacher> listOpenIdNotNull(Long minId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.ne("weixin", (Serializable)((Object)""));
        builder.gt("id", (Serializable)minId);
        return this.queryList(builder);
    }

    @Override
    public List<OrgTeacher> findStudentWithOrgAndOpenId(List<Integer> orgIds, String openId, String ... queryProps) {
        if (GenericsUtils.isNullOrEmpty(orgIds)) {
            return GenericsUtils.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.in("orgId", orgIds);
        builder.eq("weixin", (Serializable)((Object)openId));
        builder.eq("status", (Serializable)Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()));
        return this.queryList(builder);
    }

    @Override
    public List<OrgTeacher> getTeachersByMobileAndOrgIds(List<Long> orgIds, String mobile, String ... queryProps) {
        if (GenericsUtils.isNullOrEmpty(orgIds)) {
            return GenericsUtils.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.in("orgId", orgIds);
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.ne("weixin", (Serializable)((Object)""));
        builder.eq("status", (Serializable)Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()));
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<OrgTeacher> searchHasMobileAndNeedBindWithOpenId(long orgId, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(new String[]{"mobile", "id"});
        builder.ne("mobile", (Serializable)((Object)""));
        builder.eq("orgId", (Serializable)Long.valueOf(orgId));
        builder.eq("weixin", (Serializable)((Object)""));
        builder.eq("status", (Serializable)Integer.valueOf(OrgTeacherStatus.SIGNED.getCode()));
        builder.setPage(pageDto);
        builder.desc("createTime");
        return this.queryList(builder);
    }
}

