/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.constant.OrgSubAccountStatus;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.tianxiao.util.GenericsUtils;
import com.beust.jcommander.internal.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class OrgSubAccountDaoImpl
extends JdbcTemplateDaoSupport<OrgSubAccount>
implements OrgSubAccountDao {
    private static final Logger log = LoggerFactory.getLogger(OrgSubAccountDaoImpl.class);

    public OrgSubAccountDaoImpl() {
        super(OrgSubAccount.class);
    }

    @Override
    public OrgSubAccount getMasterByOrgId(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("pid", (Serializable)Integer.valueOf(0));
        builder.eq("status", (Serializable)OrgSubAccountStatus.NORMAL.getCode());
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (OrgSubAccount)this.uniqueResult(builder);
    }

    @Override
    public List<OrgSubAccount> getSlavesByMasterOrgId(Integer orgId, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("pid", (Serializable)orgId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgSubAccount> getMasterAndSlaves(Integer orgId, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.or(Expressions.eq((String)"orgId", (Serializable)orgId), Expressions.eq((String)"pid", (Serializable)orgId));
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.setOrders(Lists.newArrayList((Object[])new Order[]{Order.asc((String[])new String[]{"pid"}), Order.desc((String[])new String[]{"onlineType"}), Order.asc((String[])new String[]{"id"})}));
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgSubAccount> getSlavesIgnoreStatus(Integer orgId, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("pid", (Serializable)orgId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        return this.queryList(builder);
    }

    @Override
    public Integer getSlavesCountByMasterOrgId(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("pid", (Serializable)orgId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public OrgSubAccount getByOrgId(Integer orgId, String ... props) {
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (OrgSubAccount)this.uniqueResult(builder);
    }

    @Override
    public List<OrgSubAccount> getByOrgIds(Collection<Integer> orgIds, Integer status, String ... props) {
        if (CollectionUtils.isEmpty(orgIds)) {
            return Lists.newArrayList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.in("orgId", orgIds);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (null != status) {
            builder.eq("status", (Serializable)status);
        }
        return this.queryList(builder);
    }

    @Override
    public OrgSubAccount getByOrgIdIgnoreDelStatus(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        return (OrgSubAccount)this.uniqueResult(builder);
    }

    @Override
    public OrgSubAccount getSlaveIgnoreStatus(Integer orgId, Integer masterId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("pid", (Serializable)masterId);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (OrgSubAccount)this.uniqueResult(builder);
    }

    @Override
    public List<OrgSubAccount> getOrgSubAccountByOrgIds(Collection<Long> orgIds, Integer status) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("orgId", orgIds);
        if (GenericsUtils.notNullAndEmpty((Object)status)) {
            builder.eq("status", (Serializable)status);
        }
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<OrgSubAccount> getAllByPageDto(PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"orgId", "account_version"});
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public void incrVersionByOrgId(int orgId) {
        String sql = "update yunying.org_sub_account set account_version=account_version+1, update_time=:updateTime where org_id=:orgId";
        HashMap<String, Comparable<Integer>> param = new HashMap<String, Comparable<Integer>>();
        param.put("orgId", Integer.valueOf(orgId));
        param.put("updateTime", new Date());
        this.getNamedJdbcTemplate().update(sql, param);
    }

    @Override
    public void deleteByOrgid(int orgId) {
        String sql = "update yunying.org_sub_account set isdel=1, account_version=account_version+1, update_time=:updateTime where org_id=:orgId";
        HashMap<String, Comparable<Integer>> param = new HashMap<String, Comparable<Integer>>();
        param.put("orgId", Integer.valueOf(orgId));
        param.put("updateTime", new Date());
        this.getNamedJdbcTemplate().update(sql, param);
    }

    @Override
    public OrgSubAccount getByOrgIdIgnoreIsdel(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        return (OrgSubAccount)this.uniqueResult(builder);
    }

    @Override
    public void resetOrgWechatType(Integer orgId) {
        if (orgId == null) {
            return;
        }
        String sql = "update yunying.org_sub_account set org_wechat_type = 1,update_time=:updateTime where pid = :orgId";
        HashMap<String, Comparable<Integer>> param = new HashMap<String, Comparable<Integer>>();
        param.put("orgId", orgId);
        param.put("updateTime", new Date());
        this.getNamedJdbcTemplate().update(sql, param);
        log.info("orgId :{} need to reset orgWechatType ", (Object)orgId);
    }
}

