/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.org.dao.impl;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dto.query.AutoMatchQueryRequest;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.Expression;
import com.baijia.tianxiao.sqlbuilder.bean.Order;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;
import com.baijia.tianxiao.util.AutoMatchUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.query.BatchQueryCallback;
import com.baijia.tianxiao.util.query.ListBatchQueryTemplate;
import com.baijia.tianxiao.util.query.MapBatchQueryTemplate;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository
public class OrgStudentDaoImpl
extends JdbcTemplateDaoSupport<OrgStudent>
implements OrgStudentDao {
    private static final Logger log = LoggerFactory.getLogger(OrgStudentDaoImpl.class);
    public static final List<Integer> emptyLessonStatus = Arrays.asList(1, 2, 3);

    public OrgStudentDaoImpl() {
        super(OrgStudent.class);
    }

    @Override
    public OrgStudent getStudent(Long orgId, Long userId, Integer delStatus, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        if (delStatus != null && delStatus >= 0) {
            builder.eq("delStatus", (Serializable)delStatus);
        } else {
            builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        }
        return (OrgStudent)((Object)this.uniqueResult(builder));
    }

    @Override
    public OrgStudent getStudentByUserId(Long orgId, Long userId, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        List students = this.queryList(builder);
        if (students != null && students.size() > 0) {
            return (OrgStudent)((Object)students.get(0));
        }
        return null;
    }

    @Override
    public List<OrgStudent> getStudentsByPage(PageDto pageDto) {
        String sql = "select id,org_id,mobile,student_name from yunying.org_students limit :start,:size";
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("start", (pageDto.getPageNum() - 1) * pageDto.getPageSize());
        map.put("size", pageDto.getPageSize());
        return this.getNamedJdbcTemplate().query(sql, map, (RowMapper)new RowMapper<OrgStudent>(){

            public OrgStudent mapRow(ResultSet rs, int rowNum) throws SQLException {
                OrgStudent student = new OrgStudent();
                student.setId(rs.getLong("id"));
                student.setMobile(rs.getString("mobile"));
                student.setOrgId(rs.getLong("org_id"));
                student.setName(rs.getString("student_name"));
                return student;
            }
        });
    }

    @Override
    public List<OrgStudent> getStudentId(Long orgId, String mobile, Integer delStatus, String name, String ... propes) {
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{name}), (Object)"\u5b66\u751f\u59d3\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile}), (Object)"\u5b66\u751f\u624b\u673a\u53f7\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        SingleSqlBuilder builder = this.createSqlBuilder(propes);
        builder.eq("orgId", (Serializable)orgId);
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            builder.eq("name", (Serializable)((Object)name));
        }
        if (StringUtils.isNotEmpty((CharSequence)mobile)) {
            Expression exp = Expressions.eq((String)"mobile", (Serializable)((Object)mobile));
            exp = Expressions.or((Expression)exp, (Expression)Expressions.eq((String)"showMobile", (Serializable)((Object)mobile)));
            builder.add(exp);
        }
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        builder.desc("id");
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudents(Long orgId, String searchKey, Integer delStatus, PageDto page, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{searchKey})) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.like((String)"name", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"nickName", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"pinyin", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"mobile", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE)}));
        }
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        builder.setPage(page);
        builder.asc("name", true);
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudents(Long orgId, List<Long> userIds, String searchKey, Integer delStatus, PageDto page, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{searchKey})) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.like((String)"name", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"nickName", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"pinyin", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"mobile", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE)}));
        }
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.in("userId", userIds);
        }
        builder.setPage(page);
        builder.asc("name", true);
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudentByOrgIdAndCourseName(Long orgId, String searchKey) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (StringUtils.isNotBlank((CharSequence)searchKey)) {
            builder.like("name", (Serializable)((Object)searchKey), MatchMode.ANYWHERE);
        }
        List list = this.queryList(builder);
        log.debug("list = {}", (Object)list);
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudentList(Long orgId, String searchKey, Integer delStatus, PageDto page, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{searchKey})) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.like((String)"name", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"nickName", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"pinyin", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"mobile", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE)}));
        }
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        builder.setPage(page);
        builder.asc("pinyin");
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudentList(int orgId, List<Integer> lessonStatus, Collection<Long> addCascadeIds, Collection<Long> studentIds, boolean asc, PageDto dto) {
        HashMap params = Maps.newHashMap();
        params.put("orgId", orgId);
        if (GenericsUtils.isNullOrEmpty(lessonStatus)) {
            lessonStatus = emptyLessonStatus;
        }
        StringBuilder sqlBuilder = new StringBuilder(" AND ( 1 != 1 ");
        boolean isChange = false;
        if (GenericsUtils.notNullAndEmpty(studentIds)) {
            isChange = true;
            sqlBuilder.append(" OR user_id in (:userIds) ");
            params.put("userIds", studentIds);
        }
        if (GenericsUtils.notNullAndEmpty(addCascadeIds)) {
            isChange = true;
            sqlBuilder.append(" OR add_cascade_id in (:addCascadeIds) ");
            params.put("add_cascade_id", addCascadeIds);
        }
        if (isChange) {
            sqlBuilder.append(")");
        } else {
            sqlBuilder.append(" OR 1=1 )");
        }
        params.put("lessonStatus", lessonStatus);
        int pageIndex = (dto.getPageNum() - 1) * dto.getPageSize();
        params.put("pageIndex", pageIndex);
        params.put("pageSize", dto.getPageSize());
        String sort = asc ? "asc" : "desc";
        String fromTable = "(select id,student_name,lesson_status, mobile ,weixin,user_id,pinyin,avatar  from yunying.org_students where org_id=:orgId AND del_status =  0  AND lesson_status IN (:lessonStatus) " + sqlBuilder.toString() + " and  pinyin >= 'A' and pinyin < '{')   union all  (select id,student_name, lesson_status,mobile ,weixin,user_id, CONCAT('~',pinyin) as pinyin,avatar from yunying.org_students where org_id=:orgId AND del_status =  0  AND lesson_status IN (:lessonStatus) " + sqlBuilder.toString() + " and  ( pinyin < 'A' or pinyin >= '{'))  order by pinyin " + sort + " limit :pageIndex,:pageSize";
        String countSql = "select count(*) as count from yunying.org_students where org_id=:orgId AND del_status =  0 " + sqlBuilder.toString() + " AND lesson_status IN (:lessonStatus) ";
        final ArrayList orgStudents = Lists.newArrayList();
        this.getNamedJdbcTemplate().query(fromTable, (Map)params, (ResultSetExtractor)new ResultSetExtractor<OrgStudent>(){

            public OrgStudent extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    OrgStudent os = new OrgStudent();
                    os.setId(rs.getLong("id"));
                    os.setName(rs.getString("student_name"));
                    os.setMobile(rs.getString("mobile"));
                    os.setWeixin(rs.getString("weixin"));
                    os.setLessonStatus(rs.getInt("lesson_status"));
                    os.setUserId(rs.getLong("user_id"));
                    os.setPinyin(rs.getString("pinyin"));
                    os.setAvatar(rs.getLong("avatar"));
                    orgStudents.add(os);
                }
                return null;
            }
        });
        Integer totalCount = (Integer)this.getNamedJdbcTemplate().query(countSql, (Map)params, (ResultSetExtractor)new ResultSetExtractor<Integer>(){

            public Integer extractData(ResultSet rs) throws SQLException, DataAccessException {
                if (rs.next()) {
                    return rs.getInt("count");
                }
                return 0;
            }
        });
        dto.setCount(totalCount);
        return orgStudents;
    }

    @Override
    public List<OrgStudent> getStudentsNotInUserIds(Long orgId, Collection<Long> usrIds, String searchKey, Integer delStatus, PageDto page, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        if (StringUtils.isNotEmpty((CharSequence)searchKey)) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.like((String)"name", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"nickName", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"pinyin", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"mobile", (Serializable)((Object)searchKey), (MatchMode)MatchMode.ANYWHERE)}));
        }
        if (CollectionUtils.isNotEmpty(usrIds)) {
            builder.notin("userId", usrIds);
        }
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        builder.setPage(page);
        builder.asc("pinyin", true);
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudentsUserIdsSortedByPinyin(Long orgId, String searchKey, Integer delStatus, PageDto page) {
        HashMap params = Maps.newHashMap();
        StringBuilder sql = new StringBuilder(" select *,if(pinyin < 'A' || pinyin >= '{','~',pinyin) as py from yunying.org_students where 1=1 ");
        sql.append(" and org_id=:orgId");
        params.put("orgId", orgId);
        if (delStatus != null) {
            sql.append(" and del_status=:delStatus");
            params.put("delStatus", delStatus);
        }
        if (StringUtils.isNotEmpty((CharSequence)searchKey)) {
            sql.append(" and ( ");
            sql.append(" student_name like :searchKey");
            sql.append(" or nick_name like :searchKey");
            sql.append(" or pinyin like :searchKey");
            sql.append(" or mobile like :searchKey)");
            params.put("searchKey", "%" + searchKey + "%");
        }
        int pageIndex = (page.getPageNum() - 1) * page.getPageSize();
        sql.append(" order by py ");
        String countSql = sql.toString();
        sql.append("limit :pageIndex,:pageSize ;");
        params.put("pageIndex", pageIndex);
        params.put("pageSize", page.getPageSize());
        log.info("getStudent SortedByPinyin sql:{}", (Object)sql);
        List result = this.getNamedJdbcTemplate().query(sql.toString(), (Map)params, (RowMapper)new RowMapper<OrgStudent>(){

            public OrgStudent mapRow(ResultSet rs, int rowNum) throws SQLException {
                OrgStudent os = new OrgStudent();
                os.setId(rs.getLong("id"));
                os.setName(rs.getString("student_name"));
                os.setNickName(rs.getString("nick_name"));
                os.setParentName(rs.getString("parent_name"));
                os.setParentMobile(rs.getString("parent_mobile"));
                os.setSchool(rs.getString("school"));
                os.setRollNumber(rs.getString("roll_number"));
                os.setMobile(rs.getString("mobile"));
                os.setShowMobile(rs.getString("show_mobile"));
                os.setBranchId(rs.getLong("branch_id"));
                os.setCreateTime(rs.getDate("create_time"));
                os.setUpdateTime(rs.getDate("update_time"));
                os.setDelStatus(rs.getInt("del_status"));
                os.setOrgId(rs.getLong("org_id"));
                os.setAvatar(rs.getLong("avatar"));
                os.setUserId(rs.getLong("user_id"));
                os.setSource(rs.getInt("source"));
                os.setBirthday(rs.getDate("birthday"));
                os.setRemark(rs.getString("remark"));
                os.setWeixin(rs.getString("weixin"));
                os.setNextRemindTime(rs.getDate("next_remind_time"));
                os.setQq(rs.getString("qq"));
                os.setMail(rs.getString("mail"));
                os.setDegreeClass(rs.getString("degree_class"));
                os.setAddress(rs.getString("address"));
                os.setFatherOccupation(rs.getString("father_occupation"));
                os.setMatherOccupation(rs.getString("mather_occupation"));
                os.setAdvisoryStatus(rs.getInt("advisory_status"));
                os.setOrigin(rs.getInt("origin"));
                os.setPinyin(rs.getString("pinyin"));
                os.setLatitude(rs.getDouble("latitude"));
                os.setLongitude(rs.getDouble("longitude"));
                os.setAreaId(rs.getLong("area_id"));
                os.setGender(rs.getInt("gender"));
                os.setRelationship(rs.getInt("relationship"));
                os.setLessonStatus(rs.getInt("lesson_status"));
                os.setAddCascadeId(rs.getInt("add_cascade_id"));
                return os;
            }
        });
        page.setCount((Integer)this.getNamedJdbcTemplate().query(countSql.toString().replace("*", "count(*) as count"), (Map)params, (ResultSetExtractor)new ResultSetExtractor<Integer>(){

            public Integer extractData(ResultSet rs) throws SQLException, DataAccessException {
                rs.next();
                return rs.getInt("count");
            }
        }));
        page.setCurPageCount(Integer.valueOf(result.size()));
        return result;
    }

    public static void main(String[] args) {
        OrgStudentDaoImpl impl = new OrgStudentDaoImpl();
        PageDto page = new PageDto();
        page.setPageNum(Integer.valueOf(2));
        page.setPageSize(Integer.valueOf(20));
        impl.getStudentsUserIdsSortedByPinyin(1234L, "waba", 1, page);
    }

    @Override
    public List<OrgStudent> getStudents(final Long orgId, Collection<Long> userIds, final Integer delStatus, final PageDto page, final String ... queryProps) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        return (List)batchQueryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(queryProps);
                builder.eq("orgId", (Serializable)orgId);
                if (page != null) {
                    builder.setPage(page);
                }
                if (delStatus != null) {
                    builder.eq("delStatus", (Serializable)delStatus);
                }
                builder.in("userId", querySet);
                builder.asc("name", true);
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public List<OrgStudent> getStudents(Date createTime, Integer delStatus, PageDto page, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.gt("createTime", (Serializable)createTime);
        builder.setPage(page);
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudents(final Long orgId, Collection<String> mobiles, final Integer delStatus, final String ... queryProps) {
        if (CollectionUtils.isEmpty(mobiles)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate batchQueryTemplate = new ListBatchQueryTemplate();
        return (List)batchQueryTemplate.batchQuery(mobiles, (BatchQueryCallback)new BatchQueryCallback<String, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<String> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(queryProps);
                builder.eq("orgId", (Serializable)orgId);
                if (delStatus != null) {
                    builder.eq("delStatus", (Serializable)delStatus);
                }
                builder.in("mobile", querySet);
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public OrgStudent getStudentByMobileAndOrgId(Long orgId, String mobile, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile}), (Object)"mobile can not be empty!");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("createTime");
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.setMaxSize(Integer.valueOf(1));
        return (OrgStudent)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<OrgStudent> getStudentByMobileAndOrgId(Long orgId, String mobile, Integer maxSize, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile}), (Object)"mobile can not be empty!");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("createTime");
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (maxSize != null && maxSize > 0) {
            builder.setMaxSize(maxSize);
        }
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudentByOpenIdAndOrgId(Long orgId, String weixinOpenId, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("weixin", (Serializable)((Object)weixinOpenId));
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("createTime");
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public OrgStudent getLastStudentByMobileOrParentMobile(Long orgId, String mobile, String ... queryProps) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((boolean)StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mobile}), (Object)"mobile can not be empty!");
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        Expression expression = Expressions.or((Expression)Expressions.eq((String)"mobile", (Serializable)((Object)mobile)), (Expression)Expressions.and((Expression)Expressions.ne((String)"mobile", (Serializable)((Object)mobile)), (Expression)Expressions.eq((String)"parentMobile", (Serializable)((Object)mobile))));
        builder.add(expression);
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("createTime");
        builder.setMaxSize(Integer.valueOf(1));
        return (OrgStudent)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<OrgStudent> getStudentByIds(final Long orgId, Collection<Long> studentIds, final String ... propes) {
        if (studentIds.isEmpty()) {
            log.warn("student ids is empty.");
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List students = (List)queryTemplate.batchQuery(studentIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(propes);
                builder.in("id", querySet);
                builder.eq("orgId", (Serializable)orgId);
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
        return students;
    }

    @Override
    public List<OrgStudent> getStudentByUserIds(final Long orgId, Collection<Long> userIds, final String ... propes) {
        if (CollectionUtils.isEmpty(userIds)) {
            log.warn("user ids is empty.");
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List students = (List)queryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(propes);
                builder.in("userId", querySet);
                builder.eq("orgId", (Serializable)orgId);
                builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
        return students;
    }

    @Override
    public List<OrgStudent> getStudentByUserIdsAndDelStatus(final Long orgId, Collection<Long> userIds, final Integer delStatus, final String ... propes) {
        if (userIds.isEmpty()) {
            log.warn("user ids is empty.");
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List students = (List)queryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(propes);
                builder.in("userId", querySet);
                builder.eq("orgId", (Serializable)orgId);
                if (null != delStatus) {
                    builder.eq("delStatus", (Serializable)delStatus);
                }
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
        return students;
    }

    @Override
    public List<OrgStudent> getPageStudentByUserIds(final Long orgId, Collection<Long> userIds, final Collection<Long> inStudentIds, final PageDto pageDto) {
        if (userIds.isEmpty()) {
            log.warn("user ids is empty.");
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List students = (List)queryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("userId", querySet);
                if (!inStudentIds.isEmpty()) {
                    builder.in("id", inStudentIds);
                }
                builder.eq("orgId", (Serializable)orgId);
                builder.setPage(pageDto);
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
        return students;
    }

    @Override
    public Long getUserId(Long studentId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        builder.eq("id", (Serializable)studentId);
        return (Long)this.queryForObject(builder, Long.class);
    }

    @Override
    public Long getStudentId(Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id"});
        builder.eq("userId", (Serializable)userId);
        return (Long)this.queryForObject(builder, Long.class);
    }

    @Override
    public Map<Long, Long> getStudentIdUserIdMap(Collection<Long> studentIds) {
        if (CollectionUtils.isEmpty(studentIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(studentIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Long>>(){

            public Map<Long, Long> doQuery(Collection<Long> studentIds) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("id", studentIds);
                final HashMap result = Maps.newHashMap();
                OrgStudentDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("id"), rs.getLong("userId"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public Map<Long, Long> getStudentUserIdAndIdMap(Collection<Long> studentIds) {
        if (CollectionUtils.isEmpty(studentIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(studentIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Long>>(){

            public Map<Long, Long> doQuery(Collection<Long> studentIds) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("id", studentIds);
                builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                final HashMap result = Maps.newHashMap();
                OrgStudentDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("userId"), rs.getLong("id"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public Map<Long, Long> getUserIdStudentIdMap(Collection<Long> userIds, Long orgId) {
        return this.getUserIdStudentIdMapWithFilter(userIds, orgId, false);
    }

    @Override
    public Map<Long, Long> getUserIdStudentIdMap(Collection<Long> userIds, Long orgId, boolean needFilterDel) {
        return this.getUserIdStudentIdMapWithFilter(userIds, orgId, true);
    }

    private Map<Long, Long> getUserIdStudentIdMapWithFilter(Collection<Long> userIds, final Long orgId, final Boolean needFilterDel) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, Long>>(){

            public Map<Long, Long> doQuery(Collection<Long> userIds) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("userId", userIds);
                builder.eq("orgId", (Serializable)orgId);
                if (needFilterDel.booleanValue()) {
                    builder.eq("delStatus", (Serializable)Integer.valueOf(0));
                }
                final HashMap result = Maps.newHashMap();
                OrgStudentDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        result.put(rs.getLong("userId"), rs.getLong("id"));
                    }
                });
                return result;
            }
        });
    }

    @Override
    public Map<Long, String> getStudentNameMap(Collection<Long> studentIds) {
        if (CollectionUtils.isEmpty(studentIds)) {
            return Collections.emptyMap();
        }
        return (Map)new MapBatchQueryTemplate().batchQuery(studentIds, (BatchQueryCallback)new BatchQueryCallback<Long, Map<Long, String>>(){

            public Map<Long, String> doQuery(Collection<Long> studentIds) {
                long current = System.currentTimeMillis();
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(new String[]{"id", "name", "nickName", "mobile"});
                builder.in("id", studentIds);
                final HashMap result = Maps.newHashMap();
                OrgStudentDaoImpl.this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

                    public void processRow(ResultSet rs) throws SQLException {
                        if (StringUtils.isBlank((CharSequence)rs.getString("name"))) {
                            if (StringUtils.isNotBlank((CharSequence)rs.getString("nickName"))) {
                                result.put(rs.getLong("id"), rs.getString("nickName"));
                            } else {
                                result.put(rs.getLong("id"), MaskUtil.maskMobile((String)rs.getString("mobile")));
                            }
                        } else {
                            result.put(rs.getLong("id"), rs.getString("name"));
                        }
                    }
                });
                log.debug("cost:{}ms", (Object)(System.currentTimeMillis() - current));
                return result;
            }
        });
    }

    @Override
    public Map<Long, OrgStudent> getStudentMap(Collection<Long> userIds, final Long orgId, final String ... propes) {
        if (userIds.isEmpty()) {
            log.warn("user ids is empty.");
            return Maps.newHashMap();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List students = (List)queryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(propes);
                builder.eq("orgId", (Serializable)orgId);
                builder.in("userId", querySet);
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.collectMap((Collection)students, (Function)new Function<OrgStudent, Long>(){

            public Long apply(OrgStudent arg0) {
                return arg0.getUserId();
            }
        });
    }

    @Override
    public List<OrgStudent> getUserByRemindTime(Date startTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id", "orgId", "userId", "name", "nickName"});
        builder.lt("nextRemindTime", (Serializable)new Date());
        builder.gt("nextRemindTime", (Serializable)startTime);
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getUserByRemindTime(Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id", "orgId", "userId", "name", "nickName"});
        builder.lt("nextRemindTime", (Serializable)endTime);
        builder.ge("nextRemindTime", (Serializable)startTime);
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> searchHasMobileConsulter(PageDto pageDto, String format, String value) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(new String[]{"name", "nickName", "orgId"});
        builder.ne("mobile", (Serializable)((Object)""));
        builder.dateformat("birthday", format, value);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.group("mobile");
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> searchHasMobileAndNeedBindWithOpenId(Long orgId, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.select(new String[]{"mobile", "id"});
        builder.ne("mobile", (Serializable)((Object)""));
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("weixin", (Serializable)((Object)""));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.setPage(pageDto);
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudentsByUserIdsAndOrgIds(final Collection<Long> orgIds, Collection<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds) || CollectionUtils.isEmpty(orgIds)) {
            return Lists.newArrayList();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        return (List)queryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("orgId", orgIds);
                builder.in("userId", querySet);
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
    }

    @Override
    public OrgStudent getStudentByMobileAndName(Long orgId, String mobile, String studentName) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("name", (Serializable)((Object)studentName));
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("createTime");
        builder.setMaxSize(Integer.valueOf(1));
        return (OrgStudent)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<OrgStudent> getStudentsByMobileAndName(Long orgId, String mobile, String studentName) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("name", (Serializable)((Object)studentName));
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudentsLikeMobileAndName(@NonNull Long orgId, String mobile, String studentName, String ... props) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        SingleSqlBuilder builder = this.createSqlBuilder(props);
        builder.eq("orgId", (Serializable)orgId);
        if (StringUtils.isNotEmpty((CharSequence)mobile)) {
            builder.like("mobile", (Serializable)((Object)mobile), MatchMode.ANYWHERE);
        }
        if (StringUtils.isNotEmpty((CharSequence)studentName)) {
            builder.like("name", (Serializable)((Object)studentName), MatchMode.ANYWHERE);
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> getStudentsByMobileAndOrgIds(Collection<Long> orgIds, String mobile, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.in("orgId", orgIds);
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.ne("weixin", (Serializable)((Object)""));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.desc("createTime");
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> searchStudentByCustomParam(long orgId, AutoMatchQueryRequest params, Collection<Long> inStudentIds, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)Long.valueOf(orgId));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        log.debug("AutoMatchQueryRequest student={}", (Object)params);
        if (params != null) {
            AutoMatchUtils.wrap(builder, params);
        } else {
            builder.desc("id");
        }
        if (!inStudentIds.isEmpty()) {
            builder.in("id", inStudentIds);
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        log.debug("builder sql={},params={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return this.queryList(builder);
    }

    @Override
    public Map<Long, Integer> getStudentTotal(Date startDate, Date endDate, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, count(id) count from yunying.org_students where org_id in (:orgIds) and del_status = 0";
        if (startDate != null && endDate != null) {
            sql = sql + " and create_time between :startDate and :endDate";
            param.put("endDate", endDate);
            param.put("startDate", startDate);
        }
        sql = sql + " group by org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }

    @Override
    public Map<Long, Integer> getStudentTotalByStatus(List<Long> TianxiaoOrgIds, Integer lessonStatus) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, count(id) count from yunying.org_students where org_id in (:orgIds) and del_status = 0 ";
        if (lessonStatus != null) {
            param.put("lessonStatus", lessonStatus);
            sql = sql + " and lesson_status = :lessonStatus ";
        }
        sql = sql + " group by org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }

    @Override
    public Map<Long, Integer> getOrgWechatAuthorizerOfStudentTotal(List<Long> TianxiaoOrgIds) {
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select org_id, count(id) count from yunying.org_students where org_id in (:orgIds) and weixin != '' and del_status = 0 group by org_id";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    Long orgId = rs.getLong("org_id");
                    Integer count = rs.getInt("count");
                    map.put(orgId, count);
                }
                return map;
            }
        });
    }

    @Override
    public void refreshOrgStudent(Long orgId, Long id) {
        StringBuilder sb = new StringBuilder("update yunying.org_students set del_status =1 where id > :id and  org_id = :orgId");
        HashMap param = Maps.newHashMap();
        param.put("orgId", orgId);
        param.put("id", id);
        this.getNamedJdbcTemplate().update(sb.toString(), (Map)param);
    }

    @Override
    public Map<Long, OrgStudent> getOrgStudentMapByUserIds(Collection<Long> userIds) {
        if (userIds.isEmpty()) {
            log.warn("user ids is empty.");
            return Maps.newHashMap();
        }
        ListBatchQueryTemplate queryTemplate = new ListBatchQueryTemplate();
        List students = (List)queryTemplate.batchQuery(userIds, (BatchQueryCallback)new BatchQueryCallback<Long, List<OrgStudent>>(){

            public List<OrgStudent> doQuery(Collection<Long> querySet) {
                SingleSqlBuilder builder = OrgStudentDaoImpl.this.createSqlBuilder(new String[0]);
                builder.in("userId", querySet);
                return OrgStudentDaoImpl.this.queryList(builder);
            }
        });
        return CollectorUtil.collectMap((Collection)students, (Function)new Function<OrgStudent, Long>(){

            public Long apply(OrgStudent arg0) {
                return arg0.getUserId();
            }
        });
    }

    @Override
    public Map<String, Integer> getStudentTotalMap(Date startDate, Date endDate, List<Long> TianxiaoOrgIds) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select count(id) count, DATE_FORMAT(create_time,'%y-%m-%d') createTime from yunying.org_students where org_id in (:orgIds) and del_status = 0";
        if (startDate != null && endDate != null) {
            sql = sql + " and create_time between :startDate and :endDate";
            param.put("endDate", endDate);
            param.put("startDate", startDate);
        }
        sql = sql + " group by MONTH(create_time), DAY(create_time)";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<String, Integer>>(){

            public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                while (rs.next()) {
                    String createTime = rs.getString("createTime");
                    Integer count = rs.getInt("count");
                    map.put(createTime, count);
                    log.info("createTime===========" + rs.getString("createTime") + "count==========" + count);
                }
                return map;
            }
        });
    }

    @Override
    public Integer getStudentSum(Integer orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Integer getStudentSum(List<Long> orgIds) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("orgId", orgIds);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<OrgStudent> getStudentByUserId(Long userId, Integer delStatus) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("userId", (Serializable)userId);
        if (delStatus != null) {
            builder.eq("delStatus", (Serializable)delStatus);
        }
        return this.queryList(builder);
    }

    @Override
    public Integer getStudentCountByTime(Date startTime, Date endTime, Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id");
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.le("createTime", (Serializable)endTime);
        builder.ge("createTime", (Serializable)startTime);
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Map<Long, List<Long>> getUserIdMapByOrgIds(List<Long> TianxiaoOrgIds) {
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("orgIds", TianxiaoOrgIds);
        String sql = "select * from yunying.org_students where org_id in (:orgIds) and del_status = 0 ";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, List<Long>>>(){

            public Map<Long, List<Long>> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>();
                while (rs.next()) {
                    Long userId = rs.getLong("user_id");
                    Long orgId = rs.getLong("org_id");
                    ArrayList<Long> userIds = (ArrayList<Long>)map.get(orgId);
                    if (GenericsUtils.isNullOrEmpty((Object)userIds)) {
                        userIds = new ArrayList<Long>();
                        map.put(orgId, userIds);
                    }
                    userIds.add(userId);
                }
                return map;
            }
        });
    }

    @Override
    public List<OrgStudent> searchStudent(Long orgId, Collection<? extends Long> studentIds, boolean isAll, PageDto pageDto) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"id", "name", "nickName", "mobile", "showMobile"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        if (isAll) {
            if (GenericsUtils.notNullAndEmpty(studentIds)) {
                builder.notin("id", studentIds);
            }
        } else {
            if (GenericsUtils.isNullOrEmpty(studentIds)) {
                return Collections.emptyList();
            }
            builder.in("id", studentIds);
        }
        if (pageDto != null) {
            builder.setPage(pageDto);
        }
        String sql = builder.toSql();
        log.info("sql is : {} ", (Object)sql);
        return this.queryList(builder);
    }

    @Override
    public void batchUpdateStudentStatus(long orgId, Collection<Long> userIds, int status) {
        String sql = "update yunying.org_students set lesson_status=:status,update_time=:updateTime where org_id=:orgId AND user_id in (:ids) and lesson_status!=:status";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", status);
        map.put("orgId", orgId);
        map.put("updateTime", new Date());
        map.put("ids", userIds);
        log.info("sql={},param={}", (Object)sql, map);
        this.getNamedJdbcTemplate().update(sql, map);
    }

    @Override
    public void batchUpdateStudentToStudying(long orgId, Collection<Long> userIds) {
        String sql = "update yunying.org_students set lesson_status=1,update_time=:updateTime where org_id=:orgId AND user_id in (:ids)";
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("orgId", orgId);
        map.put("updateTime", new Date());
        map.put("ids", userIds);
        log.info("sql={},param={}", (Object)sql, map);
        this.getNamedJdbcTemplate().update(sql, map);
    }

    @Override
    public Map<Integer, Integer> getStudentCountMap(List<Integer> orgIds) {
        final HashMap data = Maps.newHashMap();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id", "num");
        builder.in("orgId", orgIds);
        builder.group("orgId");
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                data.put(rs.getInt("orgId"), rs.getInt("num"));
            }
        });
        return data;
    }

    @Override
    public Map<Integer, Integer> getStudentCountMapByStatus(List<Integer> orgIds, List<Integer> lessonStatus) {
        final HashMap data = Maps.newHashMap();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.count("id", "num");
        builder.in("orgId", orgIds);
        builder.group("orgId");
        if (GenericsUtils.notNullAndEmpty(lessonStatus)) {
            builder.in("lessonStatus", lessonStatus);
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        this.getNamedJdbcTemplate().query(builder.toSql(), builder.collectConditionValue(), new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                data.put(rs.getInt("orgId"), rs.getInt("num"));
            }
        });
        return data;
    }

    @Override
    public Map<Integer, Integer> getStatisticsByLessonStatus(int orgId, Collection<Long> studentIds) {
        String sql = "select count(1) as c,lesson_status from yunying.org_students where org_id=:orgId and del_status=0";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgId", orgId);
        if (studentIds != null && studentIds.size() > 0) {
            sql = sql + " and id in (:studentIds)";
            param.put("studentIds", studentIds);
        }
        sql = sql + " group by lesson_status";
        final HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        log.info("[Statistics] sql={},param={}", (Object)sql, param);
        this.getNamedJdbcTemplate().query(sql, param, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                ret.put(rs.getInt("lesson_status"), rs.getInt("c"));
                return null;
            }
        });
        return ret;
    }

    @Override
    public void updateStudentStatusByOrgId(Long orgId, int status) {
        String sql = "update yunying.org_students set lesson_status=:status,update_time=:updateTime where org_id=:orgId and lesson_status!=:status";
        HashMap<String, Comparable<Integer>> map = new HashMap<String, Comparable<Integer>>();
        map.put("status", Integer.valueOf(status));
        map.put("updateTime", new Date());
        map.put("orgId", orgId);
        int num = this.getNamedJdbcTemplate().update(sql, map);
        log.info("[UpdateStudentStatus] param={},number={}", map, (Object)num);
    }

    @Override
    public List<OrgStudent> getOrgStudents(Long orgId, List<String> mobiles) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        if (CollectionUtils.isEmpty(mobiles)) {
            return new ArrayList<OrgStudent>();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("mobile", mobiles);
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("createTime");
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public OrgStudent getStudent(Long orgId, String mobile, Long userId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("userId", (Serializable)userId);
        builder.eq("mobile", (Serializable)((Object)mobile));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return (OrgStudent)((Object)this.uniqueResult(builder));
    }

    @Override
    public List<Long> getStudentIdsByAdder(int cascadeId, long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        builder.eq("orgId", (Serializable)Long.valueOf(orgId));
        builder.eq("addCascadeId", (Serializable)Integer.valueOf(cascadeId));
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        List students = this.queryList(builder);
        if (students != null) {
            return ListUtil.toKeyList((Collection)students, (String)"userId", OrgStudent.class);
        }
        return Collections.emptyList();
    }

    @Override
    public List<OrgStudent> listPinYinNull(Long maxId, Integer size) {
        final ArrayList<OrgStudent> list = new ArrayList<OrgStudent>();
        String sql = "select * from yunying.org_students where pinyin='' and id>:maxId limit :size";
        HashMap<String, Number> params = new HashMap<String, Number>();
        params.put("maxId", maxId);
        params.put("size", size);
        this.getNamedJdbcTemplate().query(sql, params, (ResultSetExtractor)new ResultSetExtractor<Object>(){

            public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
                OrgStudent student = null;
                while (rs.next()) {
                    student = new OrgStudent();
                    student.setId(rs.getLong("id"));
                    student.setName(rs.getString("student_name"));
                    list.add(student);
                }
                return null;
            }
        });
        return list;
    }

    @Override
    public void replacePortrait(String oldUrl, String newUrl) {
        StringBuilder sb = new StringBuilder("UPDATE yunying.org_students SET avatar =:newUrl WHERE avatar =:oldUrl");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("oldUrl", oldUrl);
        param.put("newUrl", newUrl);
        this.getNamedJdbcTemplate().update(sb.toString(), param);
    }

    @Override
    public Map<Integer, Integer> getStatisticsDayByLessonStatus(int lessonStatus, List<Integer> orgIds) {
        String sql = "select count(1) as c,org_id from yunying.org_students where lesson_status=:lessonStatus and del_status=0 and org_id in (:orgIds)";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("lessonStatus", lessonStatus);
        param.put("orgIds", orgIds);
        sql = sql + " group by org_id";
        final HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        this.getNamedJdbcTemplate().query(sql, param, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                ret.put(rs.getInt("org_id"), rs.getInt("c"));
                return null;
            }
        });
        return ret;
    }

    @Override
    public List<OrgStudent> listOpenIdNotNull(Long minId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.ne("weixin", (Serializable)((Object)""));
        builder.gt("id", (Serializable)minId);
        return this.queryList(builder);
    }

    @Override
    public List<OrgStudent> fuzzySearchStudents(Long orgId, String param, PageDto page, String ... queryProps) {
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.eq("orgId", (Serializable)orgId);
        if (StringUtils.isNotBlank((CharSequence)param)) {
            builder.add(Expressions.or((Expression)Expressions.like((String)"name", (Serializable)((Object)param), (MatchMode)MatchMode.ANYWHERE), (Expression)Expressions.like((String)"mobile", (Serializable)((Object)param), (MatchMode)MatchMode.ANYWHERE)));
        }
        if (page != null) {
            builder.setPage(page);
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.asc("name", true);
        return this.queryList(builder);
    }

    @Override
    public void updateNextRemindTime(Long studentId) {
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("studentId", studentId);
        String sql = "update yunying.org_students set next_remind_time = 0 where id = :studentId";
        this.getNamedJdbcTemplate().update(sql, param);
    }

    @Override
    public Integer countStudentsByTime(Long orgId, Date startTime, Date endTime) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        if (startTime != null) {
            builder.ge("createTime", (Serializable)startTime);
        }
        if (endTime != null) {
            builder.le("createTime", (Serializable)endTime);
        }
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Map<Integer, Integer> getStatisticsByLessonStatus(int orgId, boolean needDataAuthority, List<Long> studentIds, Integer cascadeId) {
        String sql = "select count(1) as c,lesson_status from yunying.org_students where org_id=:orgId and del_status = 0 ";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("orgId", orgId);
        if (needDataAuthority) {
            if (GenericsUtils.notNullAndEmpty(studentIds)) {
                sql = sql + " and user_id in(:userIds) ";
                param.put("userIds", studentIds);
            }
            sql = sql + " and add_cascade_id = :addCascadeId ";
            param.put("addCascadeId", cascadeId);
        }
        sql = sql + " group by lesson_status ";
        final HashMap<Integer, Integer> ret = new HashMap<Integer, Integer>();
        log.info("[Statistics] sql={},param={}", (Object)sql, param);
        this.getNamedJdbcTemplate().query(sql, param, (RowMapper)new RowMapper<Object>(){

            public Object mapRow(ResultSet rs, int rowNum) throws SQLException {
                ret.put(rs.getInt("lesson_status"), rs.getInt("c"));
                return null;
            }
        });
        return ret;
    }

    @Override
    public Map<String, OrgStudent> getStudentByOpenIdAndOrgIdMap(Integer orgId, List<String> weixinOpenId) {
        HashMap data = Maps.newHashMap();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("weixin", weixinOpenId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        List list = this.queryList(builder);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OrgStudent student : list) {
                data.put(student.getWeixin(), student);
            }
        }
        return data;
    }

    @Override
    public Map<String, OrgStudent> getStudentHadMobileByOpenIdAndOrgIdMap(Integer orgId, List<String> weixinOpenId) {
        HashMap data = Maps.newHashMap();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("weixin", weixinOpenId);
        builder.eq("orgId", (Serializable)orgId);
        builder.desc("createTime");
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.isNotNull("mobile");
        builder.ne("mobile", (Serializable)((Object)"''"));
        List list = this.queryList(builder);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OrgStudent student : list) {
                data.put(student.getWeixin(), student);
            }
        }
        return data;
    }

    @Override
    public int getStudentHadMobileByOpenIdAndOrgIdCount(Integer orgId, List<String> weixinOpenId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("weixin", weixinOpenId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.isNotNull("mobile");
        builder.ne("mobile", (Serializable)((Object)"''"));
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public int getStudentByOpenIdAndOrgIdMapCount(Integer orgId, List<String> weixinOpenId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("weixin", weixinOpenId);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<OrgStudent> findStudentWithOrgAndOpenId(List<Integer> orgIds, String openId, String ... queryProps) {
        if (GenericsUtils.isNullOrEmpty(orgIds)) {
            return GenericsUtils.emptyList();
        }
        SingleSqlBuilder builder = this.createSqlBuilder(queryProps);
        builder.in("orgId", orgIds);
        builder.eq("weixin", (Serializable)((Object)openId));
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        return this.queryList(builder);
    }

    @Override
    public int countBySource(Long orgId, Long sourceId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("source", (Serializable)sourceId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.count("id");
        Integer count = (Integer)this.queryForObject(builder, Integer.class);
        return count == null ? 0 : count;
    }

    @Override
    public Map<Long, String> mapIdVsName(Collection<Long> ids) {
        final HashMap<Long, String> map = new HashMap<Long, String>();
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        String sql = "SELECT id,student_name FROM yunying.org_students WHERE id IN (:ids)";
        HashMap<String, Collection<Long>> params = new HashMap<String, Collection<Long>>();
        params.put("ids", ids);
        template.query(sql, params, (RowMapper)new RowMapper<Long>(){

            public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
                map.put(rs.getLong("id"), rs.getString("student_name"));
                return 0L;
            }
        });
        return map;
    }

    @Override
    public Map<Long, OrgStudent> mapKeyUserId(Long orgId, String keyword) {
        HashMap<Long, OrgStudent> map = new HashMap<Long, OrgStudent>();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            builder.like("name", (Serializable)((Object)keyword), MatchMode.ANYWHERE);
        }
        builder.eq("delStatus", (Serializable)Integer.valueOf(0));
        List list = this.queryList(builder);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OrgStudent os : list) {
                map.put(os.getUserId(), os);
            }
        }
        return map;
    }

    @Override
    public List<Long> listUserId(Long orgId, String keyword) {
        final ArrayList<Long> result = new ArrayList<Long>();
        NamedParameterJdbcTemplate template = this.getNamedJdbcTemplate();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder builder = new StringBuilder();
        builder.append("SELECT user_id FROM yunying.org_students WHERE 1=1");
        builder.append(" AND org_id=:orgId");
        if (StringUtils.isNotBlank((CharSequence)keyword)) {
            builder.append(" AND student_name like :keyword");
        }
        params.put("orgId", orgId);
        params.put("keyword", "%" + keyword + "%");
        template.query(builder.toString(), params, (RowMapper)new RowMapper<Integer>(){

            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                result.add(rs.getLong("user_id"));
                return 1;
            }
        });
        return result;
    }

    @Override
    public Map<String, OrgStudent> getStudentByMobilesAndOrgIdMap(Integer orgId, List<String> mobiles) {
        HashMap data = Maps.newHashMap();
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("mobile", mobiles);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        List list = this.queryList(builder);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            for (OrgStudent student : list) {
                data.put(student.getMobile(), student);
            }
        }
        return data;
    }

    @Override
    public List<Long> getDelUserIds(Long orgId) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[]{"userId"});
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.DELETED.getValue()));
        return Lists.transform((List)this.queryList(builder), (Function)new Function<OrgStudent, Long>(){

            public Long apply(OrgStudent input) {
                return input.getUserId();
            }
        });
    }

    @Override
    public List<OrgStudent> getWxListByParam(Long orgId, String key, Collection<Long> userIds, Integer enableStatus, Collection<Integer> lessonStatus, Date start, Date end, PageDto pageDto) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("orgId", (Serializable)orgId);
        builder.eq("delStatus", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        if (StringUtils.isNotBlank((CharSequence)key)) {
            builder.add(Expressions.or((Expression[])new Expression[]{Expressions.like((String)"name", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"nickName", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE), Expressions.like((String)"mobile", (Serializable)((Object)key), (MatchMode)MatchMode.ANYWHERE)}));
        }
        if (CollectionUtils.isNotEmpty(userIds)) {
            builder.in("userId", userIds);
        }
        if (enableStatus != null) {
            builder.eq("enableStatus", (Serializable)enableStatus);
        }
        if (CollectionUtils.isNotEmpty(lessonStatus)) {
            builder.in("lessonStatus", lessonStatus);
        }
        if (start != null) {
            builder.ge("createTime", (Serializable)start);
        }
        if (end != null) {
            builder.lt("createTime", (Serializable)end);
        }
        builder.setPage(pageDto);
        builder.addOrder(Order.asc((boolean)true, (String[])new String[]{"name"}));
        builder.addOrder(Order.desc((String[])new String[]{"createTime"}));
        return this.queryList(builder);
    }

    @Override
    public Map<String, Integer> getStudentCount(Long orgId, Date start, Date end) {
        HashMap<String, Comparable<Long>> param = new HashMap<String, Comparable<Long>>();
        param.put("orgId", orgId);
        String sql = "select count(id) count, DATE_FORMAT(create_time,'%Y-%m-%d') createTime from yunying.org_students where org_id = (:orgId) and del_status = 0";
        if (start != null && end != null) {
            sql = sql + " and create_time between :startDate and :endDate";
            param.put("endDate", end);
            param.put("startDate", start);
        }
        sql = sql + " group by createTime";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<String, Integer>>(){

            public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                while (rs.next()) {
                    map.put(rs.getString("createTime"), rs.getInt("count"));
                }
                return map;
            }
        });
    }
}

