/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.msg.po;

import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.SendMsgErrorCode;
import com.baijia.tianxiao.exception.MsgSendException;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Entity(name="tx_sms_count")
@Table(catalog="yunying")
public class TxSmsCount {
    private static final Logger log = LoggerFactory.getLogger(TxSmsCount.class);
    @Id
    @GeneratedValue
    private Long id;
    @Column
    private Long orgId;
    @Column
    private int leftFreeCount;
    @Column
    private int usedFreeCount;
    @Column
    private int leftBuyCount;
    @Column
    private int usedBuyCount;
    @Column
    private Date createTime;
    @Column
    private Date updateTime;

    public void decreaseMsgCount(int count) {
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"count must great than 0");
        if (this.leftFreeCount > 0) {
            this.leftFreeCount -= count;
            this.usedFreeCount += count;
        } else if (this.leftBuyCount > 0) {
            this.leftFreeCount -= count;
            this.usedFreeCount += count;
        } else {
            log.warn("left msg count is out of range:{}", (Object)this);
            throw new MsgSendException((UniverseErrorCode)SendMsgErrorCode.NOT_SMS_COUNT);
        }
    }

    public Long getId() {
        return this.id;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public int getLeftFreeCount() {
        return this.leftFreeCount;
    }

    public int getUsedFreeCount() {
        return this.usedFreeCount;
    }

    public int getLeftBuyCount() {
        return this.leftBuyCount;
    }

    public int getUsedBuyCount() {
        return this.usedBuyCount;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public void setLeftFreeCount(int leftFreeCount) {
        this.leftFreeCount = leftFreeCount;
    }

    public void setUsedFreeCount(int usedFreeCount) {
        this.usedFreeCount = usedFreeCount;
    }

    public void setLeftBuyCount(int leftBuyCount) {
        this.leftBuyCount = leftBuyCount;
    }

    public void setUsedBuyCount(int usedBuyCount) {
        this.usedBuyCount = usedBuyCount;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TxSmsCount)) {
            return false;
        }
        TxSmsCount other = (TxSmsCount)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$orgId = this.getOrgId();
        Long other$orgId = other.getOrgId();
        if (this$orgId == null ? other$orgId != null : !((Object)this$orgId).equals(other$orgId)) {
            return false;
        }
        if (this.getLeftFreeCount() != other.getLeftFreeCount()) {
            return false;
        }
        if (this.getUsedFreeCount() != other.getUsedFreeCount()) {
            return false;
        }
        if (this.getLeftBuyCount() != other.getLeftBuyCount()) {
            return false;
        }
        if (this.getUsedBuyCount() != other.getUsedBuyCount()) {
            return false;
        }
        Date this$createTime = this.getCreateTime();
        Date other$createTime = other.getCreateTime();
        if (this$createTime == null ? other$createTime != null : !((Object)this$createTime).equals(other$createTime)) {
            return false;
        }
        Date this$updateTime = this.getUpdateTime();
        Date other$updateTime = other.getUpdateTime();
        return !(this$updateTime == null ? other$updateTime != null : !((Object)this$updateTime).equals(other$updateTime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TxSmsCount;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $orgId = this.getOrgId();
        result = result * 59 + ($orgId == null ? 43 : ((Object)$orgId).hashCode());
        result = result * 59 + this.getLeftFreeCount();
        result = result * 59 + this.getUsedFreeCount();
        result = result * 59 + this.getLeftBuyCount();
        result = result * 59 + this.getUsedBuyCount();
        Date $createTime = this.getCreateTime();
        result = result * 59 + ($createTime == null ? 43 : ((Object)$createTime).hashCode());
        Date $updateTime = this.getUpdateTime();
        result = result * 59 + ($updateTime == null ? 43 : ((Object)$updateTime).hashCode());
        return result;
    }

    public String toString() {
        return "TxSmsCount(id=" + this.getId() + ", orgId=" + this.getOrgId() + ", leftFreeCount=" + this.getLeftFreeCount() + ", usedFreeCount=" + this.getUsedFreeCount() + ", leftBuyCount=" + this.getLeftBuyCount() + ", usedBuyCount=" + this.getUsedBuyCount() + ", createTime=" + this.getCreateTime() + ", updateTime=" + this.getUpdateTime() + ")";
    }
}

