/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.index.dao.impl;

import com.baijia.tianxiao.dal.index.constant.TxVisitorStatus;
import com.baijia.tianxiao.dal.index.dao.TxVisitorDao;
import com.baijia.tianxiao.dal.index.po.TxVisitor;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TxVisitorDaoImpl
extends JdbcTemplateDaoSupport<TxVisitor>
implements TxVisitorDao {
    private static final Logger log = LoggerFactory.getLogger(TxVisitorDaoImpl.class);

    public TxVisitorDaoImpl() {
        super(TxVisitor.class);
    }

    @Override
    public List<TxVisitor> listByTime(Date startDay, Date endDate) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("applyType", (Serializable)Integer.valueOf(0));
        builder.ge("createTime", (Serializable)startDay);
        builder.le("createTime", (Serializable)endDate);
        builder.between("createTime", (Comparable)startDay, (Comparable)endDate);
        return this.queryList(builder);
    }

    @Override
    public Integer getActiveCount() {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("status", (Serializable)Integer.valueOf(TxVisitorStatus.ACTIVE.getCode()));
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public List<TxVisitor> getByMobile(String mobile) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("mobile", (Serializable)((Object)mobile));
        return this.queryList(builder);
    }

    @Override
    public List<TxVisitor> releaseAccount(Date startTime, Date endDate) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("isdel", (Serializable)Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        builder.eq("applyType", (Serializable)Integer.valueOf(0));
        builder.eq("status", (Serializable)Integer.valueOf(TxVisitorStatus.ACTIVE.getCode()));
        builder.ge("startTime", (Serializable)startTime);
        builder.lt("startTime", (Serializable)endDate);
        log.debug("TxVisitorServce relaeasAccount = sql={},params={}", (Object)builder.toSql(), (Object)builder.collectConditionValue());
        return this.queryList(builder);
    }

    @Override
    public void updateByMobile(TxVisitor tx) {
        String sql = "update yunying.tx_visitor set org_name=?,name=?,province=?,city=?,province_id=?,city_id=?,remark=?,apply_type=?,source=?,status=?,create_time=?,update_time=?,isdel=? where mobile=?";
        this.getNamedJdbcTemplate().getJdbcOperations().update(sql, new Object[]{tx.getOrgName(), tx.getName(), tx.getProvince(), tx.getCity(), tx.getProvinceId(), tx.getCityId(), tx.getRemark(), tx.getApplyType(), tx.getSource(), tx.getStatus(), tx.getCreateTime(), tx.getUpdateTime(), tx.getIsdel(), tx.getMobile()});
    }

    @Override
    public void modifyPassword(String mobile, String encryptPwd) {
        String sql = "update yunying.tx_visitor set password=:password where mobile=:mobile";
        HashMap params = Maps.newHashMap();
        params.put("mobile", mobile);
        params.put("password", encryptPwd);
        this.getNamedJdbcTemplate().update(sql, (Map)params);
    }

    @Override
    public void updateStatus(int status, String password, int id) {
        HashMap params = Maps.newHashMap();
        params.put("status", status + "");
        params.put("password", password);
        params.put("id", id + "");
        String sql = "update yunying.tx_visitor set status = :status,password = :password,update_time = now(),start_time = now(),remain_day=6 where id = :id";
        this.getNamedJdbcTemplate().update(sql, (Map)params);
    }
}

