/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.commons.configs;

import com.baijia.tianxiao.dal.commons.configs.ConfigParser;
import com.baijia.tianxiao.dal.commons.configs.KeyHolder;
import com.baijia.tianxiao.util.GenericsUtils;
import com.google.common.collect.Maps;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericsConfiguration
extends KeyHolder {
    private static final Logger log = LoggerFactory.getLogger(GenericsConfiguration.class);
    public static final Map<String, ConfigParser<?>> parsers = Maps.newHashMap();
    private static Map<String, Object> configs = Maps.newConcurrentMap();

    public static void setConfiguration(String key, String configValueJson) {
        if (GenericsUtils.isNullOrEmpty((Object)configValueJson) || GenericsUtils.isNullOrEmpty((Object)configValueJson)) {
            return;
        }
        ConfigParser<?> parser = parsers.get(key);
        String newValue = configValueJson;
        if (parser != null) {
            newValue = parser.parserConfig(configValueJson);
        }
        Object oldValue = configs.put(key, newValue);
        log.info("old value {}  ----> new Value {} ", oldValue, (Object)newValue);
    }

    public static void registeParser(Class<? extends ConfigParser<?>> parserClass) {
        if (parserClass == null) {
            return;
        }
        try {
            ConfigParser<?> newInstance = parserClass.newInstance();
            parsers.put(newInstance.getKey(), newInstance);
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
    }

    public static boolean needForceReGetJsApiTicket() {
        Object object = configs.get("FORCED_RE_GET_JS_API");
        return object == null ? false : (object instanceof Boolean ? (Boolean)object : false);
    }
}

