/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.callservice.constant;

import com.baijia.tianxiao.dal.callservice.constant.CallServiceCdrStatus;
import com.google.common.collect.Maps;
import java.util.Map;

public enum RLCallStatus {
    UNKNOW("0", "\u672a\u77e5"),
    CANCEL("1", "\u901a\u8bdd\u4e2d\u53d6\u6d88\u56de\u62e8\u3001\u76f4\u62e8\u548c\u5916\u547c\u7684\u6b63\u5e38\u7ed3\u675f\u901a\u8bdd"),
    TIME_EXHAUSTED("2", "\u8d26\u6237\u6b20\u8d39\u6216\u8005\u8bbe\u7f6e\u7684\u901a\u8bdd\u65f6\u95f4\u5230"),
    SUBSCRIBER_HANGUP("3", "\u56de\u62e8\u901a\u8bdd\u4e2d\u4e3b\u53eb\u6302\u65ad\uff0c\u6b63\u5e38\u7ed3\u675f\u901a\u8bdd"),
    CUSTOMER_HANGUP("4", "\u56de\u62e8\u901a\u8bdd\u4e2d\u88ab\u53eb\u6302\u65ad\uff0c\u6b63\u5e38\u7ed3\u675f\u901a\u8bdd"),
    CUSTOMER_HANGUP_BEFORE_RING("-1", "\u88ab\u53eb\u6ca1\u6709\u632f\u94c3\u5c31\u6536\u5230\u4e86\u6302\u65ad\u6d88\u606f"),
    CALL_TIME_OUT("-2", "\u547c\u53eb\u8d85\u65f6\u6ca1\u6709\u63a5\u901a\u88ab\u6302\u65ad"),
    SUBSCRIBER_HANGUP_AFTER_RING("-3", "\u56de\u62e8\u4e3b\u53eb\u63a5\u901a\u4e86\u4e3b\u53eb\u6302\u65ad"),
    SUBSCRIBER_HANGUP_AFTER_RING1("-4", "\u56de\u62e8\u4e3b\u53eb\u901a\u9053\u521b\u5efa\u4e86\u88ab\u6302\u65ad"),
    CUSTOMER_HANGUP_AFTER_RING("-5", "\u88ab\u53eb\u901a\u9053\u5efa\u7acb\u4e86\u88ab\u6302\u65ad"),
    CUSTOMER_HANGUP_AFTER_RING2("-9", "\u56de\u62e8\u88ab\u53eb\u632f\u94c3\u4e86\u6302\u65ad"),
    SUBSCRIBER_HANGUP_AFTER_RING2("-10", "\u56de\u62e8\u4e3b\u53eb\u632f\u94c3\u4e86\u6302\u65ad"),
    MONEY_EXHAUSTED("-11", "\u8d26\u6237\u4f59\u989d\u4e0d\u8db3"),
    INTERFACE_CANCEL("-14", "\u56de\u62e8\u53d6\u6d88\u547c\u53eb(\u901a\u8fc7\u53d6\u6d88\u56de\u62e8\u63a5\u53e3)");

    private static Map<String, String> CONNECTED;
    private static Map<String, String> LISTENER_UNCONNECT;
    private static Map<String, String> CALL_UNCONNECT;
    private String code;
    private String label;

    private RLCallStatus(String code, String label) {
        this.code = code;
        this.label = label;
    }

    public static Integer getCdrStatus(String code) {
        if (code == null) {
            return null;
        }
        if (CONNECTED.containsKey(code)) {
            return Integer.valueOf(CONNECTED.get(code));
        }
        if (LISTENER_UNCONNECT.containsKey(code)) {
            return Integer.valueOf(LISTENER_UNCONNECT.get(code));
        }
        if (CALL_UNCONNECT.containsKey(code)) {
            return Integer.valueOf(CALL_UNCONNECT.get(code));
        }
        return Integer.valueOf(UNKNOW.getCode());
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    static {
        CONNECTED = Maps.newHashMap();
        LISTENER_UNCONNECT = Maps.newHashMap();
        CALL_UNCONNECT = Maps.newHashMap();
        CONNECTED.put(RLCallStatus.CANCEL.code, CallServiceCdrStatus.CONNECTED.getCode().toString());
        CONNECTED.put(RLCallStatus.SUBSCRIBER_HANGUP.code, CallServiceCdrStatus.CONNECTED.getCode().toString());
        CONNECTED.put(RLCallStatus.CUSTOMER_HANGUP.code, CallServiceCdrStatus.CONNECTED.getCode().toString());
        LISTENER_UNCONNECT.put(RLCallStatus.TIME_EXHAUSTED.code, CallServiceCdrStatus.LISTENER_UNCONNECT.getCode().toString());
        LISTENER_UNCONNECT.put(RLCallStatus.MONEY_EXHAUSTED.code, CallServiceCdrStatus.LISTENER_UNCONNECT.getCode().toString());
        LISTENER_UNCONNECT.put(RLCallStatus.CALL_TIME_OUT.code, CallServiceCdrStatus.LISTENER_UNCONNECT.getCode().toString());
        LISTENER_UNCONNECT.put(RLCallStatus.INTERFACE_CANCEL.code, CallServiceCdrStatus.LISTENER_UNCONNECT.getCode().toString());
        LISTENER_UNCONNECT.put(RLCallStatus.CUSTOMER_HANGUP_AFTER_RING2.code, CallServiceCdrStatus.LISTENER_UNCONNECT.getCode().toString());
        LISTENER_UNCONNECT.put(RLCallStatus.CUSTOMER_HANGUP_AFTER_RING.code, CallServiceCdrStatus.LISTENER_UNCONNECT.getCode().toString());
        CALL_UNCONNECT.put(RLCallStatus.SUBSCRIBER_HANGUP_AFTER_RING1.code, CallServiceCdrStatus.CALL_UNCONNECT.getCode().toString());
        CALL_UNCONNECT.put(RLCallStatus.SUBSCRIBER_HANGUP_AFTER_RING2.code, CallServiceCdrStatus.CALL_UNCONNECT.getCode().toString());
        CALL_UNCONNECT.put(RLCallStatus.SUBSCRIBER_HANGUP_AFTER_RING.code, CallServiceCdrStatus.CALL_UNCONNECT.getCode().toString());
        CALL_UNCONNECT.put(RLCallStatus.CUSTOMER_HANGUP_BEFORE_RING.code, CallServiceCdrStatus.CALL_UNCONNECT.getCode().toString());
    }
}

