/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.dao.draw.impl;

import com.baijia.tianxiao.dal.activity.dao.draw.ActivityUserDao;
import com.baijia.tianxiao.dal.activity.po.DairyCountStatistics;
import com.baijia.tianxiao.dal.activity.po.draw.ActivityUser;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class ActivityUserDaoImpl
extends JdbcTemplateDaoSupport<ActivityUser>
implements ActivityUserDao {
    private static final Logger log = LoggerFactory.getLogger(ActivityUserDaoImpl.class);

    public ActivityUserDaoImpl() {
        super(ActivityUser.class);
    }

    @Override
    public Long insertActivityUser(ActivityUser activityUser) {
        this.save(activityUser, new String[0]);
        return activityUser.getId();
    }

    @Override
    @Deprecated
    public Map<Long, Integer> selectTotalByActivityId(List<Long> activityIds) {
        String sql = "select activity_id,count(id) as count from yunying.tx_activity_user where activity_id in (:activityIds) group by activity_id";
        HashMap<String, List<Long>> param = new HashMap<String, List<Long>>();
        param.put("activityIds", activityIds);
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    map.put(rs.getLong("activity_id"), rs.getInt("count"));
                }
                return map;
            }
        });
    }

    @Override
    public Map<Long, Integer> selectTotalByActivityIdAndCategory(List<Long> activityIds, Integer category) {
        String sql = "select activity_id,count(id) as count from yunying.tx_activity_user where activity_id in (:activityIds) and category =:category  group by activity_id";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("activityIds", activityIds);
        param.put("category", category);
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Integer>>(){

            public Map<Long, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Integer> map = new HashMap<Long, Integer>();
                while (rs.next()) {
                    map.put(rs.getLong("activity_id"), rs.getInt("count"));
                }
                return map;
            }
        });
    }

    @Override
    public Map<Long, Map<Long, Integer>> statisticalVotes(List<Long> activityIds, Integer category) {
        String sql = "select activity_id,options_id,count(*) as count from yunying.tx_activity_user where activity_id in (:activityIds) and category =:category  group by activity_id , options_id";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("activityIds", activityIds);
        param.put("category", category);
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<Long, Map<Long, Integer>>>(){

            public Map<Long, Map<Long, Integer>> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<Long, Map<Long, Integer>> map = new HashMap<Long, Map<Long, Integer>>();
                while (rs.next()) {
                    Long activityId = rs.getLong("activity_id");
                    HashMap<Long, Integer> voteResults = (HashMap<Long, Integer>)map.get(activityId);
                    if (voteResults == null) {
                        voteResults = new HashMap<Long, Integer>();
                        map.put(activityId, voteResults);
                    }
                    voteResults.put(rs.getLong("options_id"), rs.getInt("count"));
                }
                return map;
            }
        });
    }

    @Override
    public ActivityUser selectActivityUser(String wechatOpenId, String date, long activityId, int category) {
        SingleSqlBuilder sb = this.createSqlBuilder(new String[0]);
        sb.eq("wechatOpenId", (Serializable)((Object)wechatOpenId));
        if (GenericsUtils.notNullAndEmpty((Object)date)) {
            sb.eq("done_date", (Serializable)((Object)date));
        }
        sb.eq("activityId", (Serializable)Long.valueOf(activityId));
        sb.eq("category", (Serializable)Integer.valueOf(category));
        List list = this.queryList(sb);
        if (list != null && list.size() > 0) {
            return (ActivityUser)list.get(0);
        }
        return null;
    }

    @Override
    public List<ActivityUser> selectActivityUsers(String wechateOpenId, String date, Long activityId, Integer category) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("wechatOpenId", (Serializable)((Object)wechateOpenId));
        builder.eq("activityId", (Serializable)activityId);
        if (GenericsUtils.notNullAndEmpty((Object)date)) {
            builder.eq("done_date", (Serializable)((Object)date));
        }
        builder.eq("category", (Serializable)category);
        return this.queryList(builder);
    }

    @Override
    public void updateActivityUserDoneCount(ActivityUser user) {
        this.update(user, false, new String[0]);
    }

    @Override
    public List<DairyCountStatistics> selectDairyCountStatistics(long activityId, int category) {
        String sql = "select done_date,count(id) as count from yunying.tx_activity_user where activity_id=:activityId and category=:category group by done_date order by done_date desc";
        HashMap<String, Number> param = new HashMap<String, Number>();
        param.put("activityId", activityId);
        param.put("category", category);
        return (List)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<List<DairyCountStatistics>>(){

            public List<DairyCountStatistics> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<DairyCountStatistics> list = new ArrayList<DairyCountStatistics>();
                while (rs.next()) {
                    DairyCountStatistics statistics = new DairyCountStatistics();
                    statistics.setDate(rs.getString("done_date"));
                    statistics.setCount(rs.getInt("count"));
                    list.add(statistics);
                }
                return list;
            }
        });
    }

    @Override
    public List<DairyCountStatistics> selectDairyCountStatisticsWithSingle(long activityId, int category) {
        String sql = "select done_date ,count(*) as count from (select done_date,wechat_open_id  from yunying.tx_activity_user where activity_id=:activityId and category=:category group by done_date,wechat_open_id ) as a group by done_date order by done_date desc";
        HashMap<String, Number> param = new HashMap<String, Number>();
        param.put("activityId", activityId);
        param.put("category", category);
        return (List)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<List<DairyCountStatistics>>(){

            public List<DairyCountStatistics> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<DairyCountStatistics> list = new ArrayList<DairyCountStatistics>();
                while (rs.next()) {
                    DairyCountStatistics statistics = new DairyCountStatistics();
                    statistics.setDate(rs.getString("done_date"));
                    statistics.setCount(rs.getInt("count"));
                    list.add(statistics);
                }
                return list;
            }
        });
    }

    @Override
    public Integer getUserTotal(List<Long> activityIds, Integer category, Date startDate, Date endDate) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.in("activityId", activityIds);
        builder.eq("category", (Serializable)category);
        if (startDate != null) {
            builder.between("createTime", (Comparable)startDate, (Comparable)endDate);
        }
        builder.count("id");
        return (Integer)this.queryForObject(builder, Integer.class);
    }

    @Override
    public Map<String, Integer> getUserTotalMap(List<Long> activityIds, Integer category, Date startTime, Date endTime) {
        String sql = "select count(id) as count, DATE_FORMAT(create_time,'%y-%m-%d') createTime from yunying.tx_activity_user where activity_id in (:activityIds) and category=:category ";
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("activityIds", activityIds);
        param.put("category", category);
        if (startTime != null && endTime != null) {
            sql = sql + " and create_time between :startTime and :endTime ";
            param.put("endTime", endTime);
            param.put("startTime", startTime);
        }
        sql = sql + "group by MONTH(create_time), DAY(create_time)";
        return (Map)this.getNamedJdbcTemplate().query(sql, param, (ResultSetExtractor)new ResultSetExtractor<Map<String, Integer>>(){

            public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                while (rs.next()) {
                    String accessDate = rs.getString("createTime");
                    Integer count = rs.getInt("count");
                    map.put(accessDate, count);
                }
                return map;
            }
        });
    }

    @Override
    public List<ActivityUser> selectAllUsers(long activityId, int category) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("activityId", (Serializable)Long.valueOf(activityId));
        builder.eq("category", (Serializable)Integer.valueOf(category));
        return this.queryList(builder);
    }

    @Override
    public String searchFillUserInfo(String wechatOpenId, long activityId, int category) {
        SingleSqlBuilder builder = this.createSqlBuilder(new String[0]);
        builder.eq("activityId", (Serializable)Long.valueOf(activityId));
        builder.eq("category", (Serializable)Integer.valueOf(category));
        builder.eq("wechatOpenId", (Serializable)((Object)wechatOpenId));
        builder.ne("userInfo", (Serializable)((Object)""));
        List queryList = this.queryList(builder);
        log.info("sql is : {} and result is : {} ", (Object)builder.toSql(), (Object)queryList.size());
        if (GenericsUtils.notNullAndEmpty((Object)queryList)) {
            return ((ActivityUser)queryList.get(0)).getUserInfo();
        }
        return null;
    }
}

