/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.dal.activity.dao.SmsgroupSend.impl;

import com.baijia.tianxiao.dal.activity.dao.SmsgroupSend.SmsGroupSendRecordDao;
import com.baijia.tianxiao.dal.activity.po.SmsGroupSend.SmsGroupSendRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

@Repository
public class SmsGroupSendRecordDaoImpl
extends JdbcTemplateDaoSupport<SmsGroupSendRecord>
implements SmsGroupSendRecordDao {
    private static final Logger log = LoggerFactory.getLogger(SmsGroupSendRecordDaoImpl.class);

    @Override
    public List<SmsGroupSendRecord> listAllSmsGroupRecords(Long orgId, Long lastRecordId, PageDto pageDto, String ... props) {
        HashMap<String, Number> paramMap = new HashMap<String, Number>();
        paramMap.put("id", lastRecordId);
        paramMap.put("orgId", orgId);
        paramMap.put("sendStatus", 0);
        paramMap.put("firstIndex", (pageDto.getPageNum() - 1) * pageDto.getPageSize());
        paramMap.put("pageSize", pageDto.getPageSize());
        String sql = "select id from yunying.tx_sms_group_send_record o1, (select send_time from yunying.tx_sms_group_send_record where id = :id  and send_status = :sendStatus ) o2  where  o1.org_id =:orgId  and send_status = :sendStatus and (o1.send_time < o2.send_time or (o1.send_time = o2.send_time and o1.id < :id))  order by o1.send_time desc,o1.id desc limit :firstIndex,:pageSize";
        if (lastRecordId == null || lastRecordId == 0L) {
            sql = "select id from yunying.tx_sms_group_send_record where org_id = :orgId and send_status = 0  order by send_time desc , id desc limit :firstIndex,:pageSize ";
            paramMap.remove("id");
        }
        log.info("query sql is : {} and param Map is : {} ", (Object)sql, paramMap);
        return (List)this.getNamedJdbcTemplate().query(sql, paramMap, (ResultSetExtractor)new ResultSetExtractor<List<SmsGroupSendRecord>>(){

            public List<SmsGroupSendRecord> extractData(ResultSet rs) throws SQLException, DataAccessException {
                ArrayList<SmsGroupSendRecord> smsGroupSendRecords = new ArrayList<SmsGroupSendRecord>();
                while (rs.next()) {
                    log.info("resultSet is : {} ", (Object)ToStringBuilder.reflectionToString((Object)rs));
                    smsGroupSendRecords.add(this.toSmsGroupSendRecord(rs));
                }
                log.info("smsGroupSendRecords are : {}", smsGroupSendRecords);
                return smsGroupSendRecords;
            }

            private SmsGroupSendRecord toSmsGroupSendRecord(ResultSet rs) throws SQLException {
                SmsGroupSendRecord record = new SmsGroupSendRecord();
                record.setId(rs.getLong("id"));
                return record;
            }
        });
    }

    @Override
    public SmsGroupSendRecord searchRecordWithOrgId(Long recordId, Long orgId) {
        SingleSqlBuilder createSqlBuilder = this.createSqlBuilder(new String[0]);
        createSqlBuilder.eq("id", (Serializable)recordId);
        createSqlBuilder.eq("orgId", (Serializable)orgId);
        return (SmsGroupSendRecord)this.uniqueResult(createSqlBuilder);
    }

    @Override
    public List<SmsGroupSendRecord> searchRecordsWithOrgId(Long orgId, Collection<Long> newHashSet) {
        SingleSqlBuilder createSqlBuilder = this.createSqlBuilder(new String[0]);
        createSqlBuilder.eq("orgId", (Serializable)orgId);
        createSqlBuilder.in("id", newHashSet);
        return this.queryList(createSqlBuilder);
    }
}

