
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.util;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.dto.query.AutoMatchQueryRequest;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.bean.impl.MatchMode;
import com.baijia.tianxiao.sqlbuilder.util.Expressions;

/**
 * @title AutoMatchUtils
 * @desc TODO 
 * @author zhangbing
 * @date 2016年3月17日
 * @version 1.0
 */
public class AutoMatchUtils {

    public static void wrap(SingleSqlBuilder<?> builder, AutoMatchQueryRequest params) {
        String fieldName = params.getPropName();
        String orderName = params.getOrderName();
        
        if (StringUtils.isBlank(orderName)) {
            builder.desc("createTime");
        } else {
            //名字排序是根据汉语拼音的首字母来排序，因为这个地方是通用方法，有些表中没有
            //pinyin字段，最好的情况就是在注解中添加一个属性：orderName，谁用到谁再加吧
            if ("name".equals(orderName)) {
                orderName = "pinyin";
            }
            switch(params.getSortPolicy()) {
                case ASC:
                    builder.asc(orderName);
                    break;
                case DESC:
                    builder.desc(orderName);
                    break;
                default:
                    builder.desc("createTime");
                    break;
            }
        }
        
        if (StringUtils.isBlank(params.getValue())) {
            return;
        }
        switch (params.getQueryPolicy()) {
            case EQ:
                builder.eq(fieldName, params.getValue());
                break;
            case LIKE:
                if ("name".equals(fieldName)) {
                    builder.add(Expressions.or(Expressions.like(fieldName, params.getValue(), MatchMode.ANYWHERE), Expressions.like("pinyin", params.getValue(), MatchMode.ANYWHERE)));
                } else {
                    builder.like(fieldName, params.getValue(), MatchMode.ANYWHERE);
                }
                break;
            case BETWEEN:
                builder.between(fieldName, params.getStart(), params.getEnd());
                break;
            case GT:
                builder.gt(fieldName, params.getValue());
                break;
            case GE:
                builder.ge(fieldName, params.getValue());
                break;
            case LT:
                builder.lt(fieldName, params.getValue());
                break;
            case LE:
                builder.le(fieldName, params.getValue());
            case IN:
                builder.in(fieldName, params.getArr());
                break;
            default:
                break;
        }
    }
}

    