
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.wechat.po;

import java.util.Date;

import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Nov 21, 2016
 * @Desc 统一公众号关系记录表
 */
@Entity
@Table(name = "tx_unified_wechat_account", catalog = "yunying")
@Data
public class UnifiedWechatAccount {

    public static Integer MASTER_ORG_ID = 0; // 是主账号
    public static Integer IS_INIT_OVER = 0; // 初始化完成
    public static Integer NOT_INIT_OVER = -1; // 未初始化完成

    @Id
    @GeneratedValue
    @Column(name = "id")
    private Long id;

    @Column(name = "org_id")
    private Long orgId;

    @Column(name = "org_number")
    private Long orgNumber; // 机构number,冗余字段

    @Column(name = "create_time")
    private Date createTime;

    @Column(name = "update_time")
    private Date updateTime;

    @Column(name = "del_status")
    private Integer delStatus = DeleteStatus.NORMAL.getValue();

    @Column(name = "master_org_id")
    private Integer masterOrgId = 0; // 主账号的机构orgId,为0为主账号

    @Column(name = "init_status")
    private Integer initStatus = -1; // 标记总校区的公众号是否初始化 0:初始化OK,只有总校区的账号需要设置

    /**
     * @param orgId2
     * @param object
     * @param masterAccountAppId2
     * @return
     */
    public static UnifiedWechatAccount newInstance(Long orgId, Long orgNubmer, Integer masterOrgId) {
        masterOrgId = masterOrgId == null ? 0 : masterOrgId;
        UnifiedWechatAccount instance = new UnifiedWechatAccount();
        instance.setOrgId(orgId);
        instance.setOrgNumber(orgNubmer);
        instance.setMasterOrgId(masterOrgId);
        instance.setCreateTime(new Date());
        instance.setUpdateTime(new Date());
        return instance;
    }

    /**
     * @return
     */

    public boolean isInitOver() {
        return this.initStatus == 0;
    }

    /**
     * @return
     */

    public boolean isMaster() {
        return this.masterOrgId.intValue() == 0;
    }

}
