/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

import lombok.Data;

/**   
 * @title       : SubscriceQRCode 
 * @description : 服务号关注 二维码
 * @author      : zhenyujian
 * @date        : 2016年2月25日 下午4:17:37 
 */
@Entity
@Table(name = "org_wechat_subscribe_qr_code", catalog = "yunying")
@Data
public class SubscribeQRCode{
	
	@Id
	@GeneratedValue
	private Long id;
	
	@Column(name="authorizer_app_id")
	private String authorizerAppId;
	
	@Column(name="qr_code")
	private String qrCode;
	
	@Column(name="head_qr_code")
	private String headQrCode;//图文中 微信二维码

	@Column(name="create_time")
	private Date createTime;
	
	@Column(name="org_id")
	private Integer orgId;
	
	@Column(name="head_qr_code_info")
	private String headQrCodeInfo;//图文中 微信二维码 生成时使用的信息快照
	//ALTER TABLE org_wechat_subscribe_qr_code ADD head_qr_code_info varchar(512) NOT NULL DEFAULT '' COMMENT 'head_qr_code生成时使用的的信息';
	
    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
}
