/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.po;


import java.util.Date;

import lombok.Data;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

/**   
 * @title       : OrgWechatTemplate 
 * @description : 微信模板绑定记录
 * @author      : zhenyujian
 * @date        : 2016年1月6日 上午1:22:26 
 */
@Entity
@Table(name = "org_wechat_template", catalog = "yunying")
@Data
public class OrgWechatTemplate {
	
	@Id
	@GeneratedValue
	private Integer id;
	
	@Column(name="authorizer_app_id")
	private String authorizerAppId;
	
	@Column(name="original_template_id")
	private String originalTemplateId; //微信模板库中的模板id
	
	@Column(name="authorizer_template_id")
	private String authorizerTemplateId; //模板加入公众号下的模板id
	
	@Column(name="create_time")
	private Date createTime;

}

