/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.po;

import java.util.Date;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

/**
 * @title : OrgWechatReplyForSubscribe
 * @description : 微信关注自动回复规则
 * @author : zhenyujian
 * @date : 2016年1月4日 下午2:14:12
 */
@Entity
@Table(name = "org_wechat_reply_for_subscribe", catalog = "yunying")
@Data
public class OrgWechatReplyForSubscribe {

    @Id
    @GeneratedValue
    private Integer id;

    @Column(name = "authorizer_app_id")
    private String authorizerAppId;// 微信公众号appid

    @Column(name = "media_type")
    private Integer mediaType;// 回复内容所属素材类型

    @Column(name = "media_id")
    private String mediaId;// 图文素材的微信素材id

    @Column(name = "url")
    private String url;// 图片、语音等类型素材的链接地址

    @Column(name = "content")
    private String content;// 文字类型素材的文字内容

    @Column(name = "create_time")
    private Date createTime;

    @Column(name = "update_time")
    private Date updateTime;

    @Column(name = "note")
    private String note;

}
