/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.po;
import java.util.Date;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

import lombok.Data;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

/**   
 * @title       : OrgWechatFansSummary 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年1月23日 下午4:28:34 
 */
@Entity
@Table(name = "org_wechat_statistics_fans_summary", catalog = "yunying")
@Data
public class OrgWechatFansSummary {

	@Id
	@GeneratedValue
	private Integer id;
	
	@Column(name="authorizer_app_id")
	private String authorizerAppId;
	
	@Column(name="ref_date")
	private Date refDate;
	
	@Column(name="new_user")
	private Integer newUser;
	
	@Column(name="cancel_user")
	private Integer cancelUser;
	
	@Column(name="create_time")
	private Date createTime;
	
	
	
	public Integer getFansDiff(){
		return this.newUser - this.cancelUser;
	}
	
	
	@Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

    @Override
    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals(this, obj);
    }
}

