/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.po;

import java.util.Date;

import lombok.Data;

import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncStatus;
import com.baijia.tianxiao.dal.wechat.constant.WechatDataSyncType;
import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

@Data
@Entity
@Table(name = "org_wechat_data_sync_log", catalog = "yunying")
public class OrgWechatDataSyncLog {

	@Id
    @GeneratedValue
	private Long id;
	
	@Column(name="authorizer_app_id")
    private String authorizerAppId;
	
	@Column(name = "type")
    private Integer type;
	
	@Column(name = "status")
    private Integer status;
	
	@Column(name = "amount_expected")
	private Integer amountExpected;
	
	@Column(name = "amount_completed")
	private Integer amountCompleted;
	
	@Column(name = "expire_time")
    private Date expireTime;
	
	@Column(name = "start_time")
    private Date startTime;
	
	@Column(name = "end_time")
    private Date endTime;
	
	@Column(name = "create_time")
    private Date createTime;
	
	@Column(name = "update_time")
    private Date updateTime;
	
	
	public static OrgWechatDataSyncLog buildDefaultLog(String authorizerAppId, WechatDataSyncType type ,Date startTime, Integer amountExpected, Date expireTime){
		OrgWechatDataSyncLog dataSyncLog = new OrgWechatDataSyncLog();
		dataSyncLog.setAuthorizerAppId(authorizerAppId);
		dataSyncLog.setType(type.getValue());
		dataSyncLog.setStatus(WechatDataSyncStatus.ONGOING.getValue());
		dataSyncLog.setAmountExpected(amountExpected);
		dataSyncLog.setAmountCompleted(0);
		dataSyncLog.setExpireTime(expireTime);
		
		dataSyncLog.setStartTime(startTime);
		dataSyncLog.setEndTime(startTime);
		dataSyncLog.setStartTime(startTime);
		dataSyncLog.setEndTime(startTime);
		
		return dataSyncLog;
	}
	
}

