/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.wechat.dao.WechatBackupMenuDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatBackupMenu;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;


/**   
 * @title       : AuthorizationInfoDaoImpl 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2015年12月5日 下午4:21:41 
 */
@Repository("tianxiao_dal_yunying_wechatBackupMenuDao")
public class WechatBackupMenuDaoImpl extends JdbcTemplateDaoSupport<OrgWechatBackupMenu> implements WechatBackupMenuDao{

	public WechatBackupMenuDaoImpl() {
		super(OrgWechatBackupMenu.class);
	}

	@Override
	public OrgWechatBackupMenu getLatestByAppId(String authorizerAppId) {
        SingleSqlBuilder<OrgWechatBackupMenu> builder = createSqlBuilder();
        builder.eq("authorizerAppId", authorizerAppId);
        builder.desc("id");
        builder.setMaxSize(1);
        return uniqueResult(builder);
	}



	
}
