/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import java.util.HashMap;
import java.util.Map;

import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.wechat.dao.OrgWechatTemplateDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatTemplate;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

/**   
 * @title       : OrgWechatTemplateDaoImpl 
 * @description : 
 * @author      : zhenyujian
 * @date        : 2016年1月6日 上午1:26:12 
 */
@Repository
public class OrgWechatTemplateDaoImpl extends JdbcTemplateDaoSupport<OrgWechatTemplate> implements OrgWechatTemplateDao {

	public OrgWechatTemplateDaoImpl() {
		super(OrgWechatTemplate.class);
	}

	
	@Override
	public OrgWechatTemplate getByAppIdAndOriginalTemplateId(String authorizerAppId, String originalTemplateId) {
		SingleSqlBuilder<OrgWechatTemplate> builder = createSqlBuilder();
        builder.eq("authorizerAppId", authorizerAppId);
        builder.eq("originalTemplateId", originalTemplateId);
        return uniqueResult(builder);
	}


	@Override
	public void delByAppIdAndOriginalTemplateId(String authorizerAppId, String originalTemplateId) {
		NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
		
		//SQL
		String sql = "DELETE FROM yunying.org_wechat_template WHERE authorizer_app_id =:authorizerAppId AND original_template_id=:originalTemplateId";
		
		//参数
		Map<String, Object> params = new HashMap<String,Object>();
		params.put("authorizerAppId", authorizerAppId);
        params.put("originalTemplateId", originalTemplateId);
        
        //执行
        template.update(sql, params);
	}

}

