/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import java.util.List;

import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatOpenIdRecordDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatOpenIdRecord;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

@Repository
public class OrgWechatOpenIdRecordDaoImpl extends JdbcTemplateDaoSupport<OrgWechatOpenIdRecord> implements OrgWechatOpenIdRecordDao {
	
	public OrgWechatOpenIdRecordDaoImpl() {
		super(OrgWechatOpenIdRecord.class);
	}

	@Override
	public List<OrgWechatOpenIdRecord> listBy(String wechatAppId, String openId, WechatOpenIdEntityType entityType) {
		SingleSqlBuilder<OrgWechatOpenIdRecord> builder = createSqlBuilder();
        builder.eq("authorizerAppId", wechatAppId);
        builder.eq("openId", openId);
        builder.eq("entityType", entityType.getValue());
        return this.queryList(builder);
	}

	
	
	@Override
	public List<OrgWechatOpenIdRecord> listBy(String wechatAppId, Long orgId, String openId, WechatOpenIdEntityType entityType){
		SingleSqlBuilder<OrgWechatOpenIdRecord> builder = createSqlBuilder();
        builder.eq("authorizerAppId", wechatAppId);
        builder.eq("openId", openId);
        builder.eq("orgId", orgId);
        builder.eq("entityType", entityType.getValue());
        return this.queryList(builder);
	}

	@Override
	public OrgWechatOpenIdRecord getBy(String wechatAppId, Long orgId, Long entityId, WechatOpenIdEntityType entityType) {
		SingleSqlBuilder<OrgWechatOpenIdRecord> builder = createSqlBuilder();
        builder.eq("authorizerAppId", wechatAppId);
        builder.eq("orgId", orgId);
        builder.eq("entityId", entityId);
        builder.eq("entityType", entityType.getValue());
        return uniqueResult(builder);
	}

	@Override
	public List<OrgWechatOpenIdRecord> listBy(Long orgId, String openId, WechatOpenIdEntityType entityType) {
		SingleSqlBuilder<OrgWechatOpenIdRecord> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.eq("openId", openId);
        builder.eq("entityType", entityType.getValue());
        return this.queryList(builder);
	}

}
