/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import com.baijia.tianxiao.dal.wechat.dao.OrgWechatMenuDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatMenu;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @title : AuthorizationInfoDaoImpl
 * @description :
 * @author : zhenyujian
 * @date : 2015年12月5日 下午4:21:41
 */
@Repository("tianxiao_dal_yunying_orgWechatMenuDao")
public class OrgWechatMenuDaoImpl extends JdbcTemplateDaoSupport<OrgWechatMenu> implements OrgWechatMenuDao {

    public OrgWechatMenuDaoImpl() {
        super(OrgWechatMenu.class);
    }

    @Override
    public void deleteByOrgId(int orgId) {
        Map<String, Object> condition = new HashMap<String, Object>();
        condition.put("orgId", orgId);
        delByCondition(condition);
    }

    @Override
    public List<OrgWechatMenu> getByOrgId(int orgId) {
        SingleSqlBuilder<OrgWechatMenu> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        return this.queryList(builder);
    }

    @Override
    public OrgWechatMenu getById(int id) {
        SingleSqlBuilder<OrgWechatMenu> builder = createSqlBuilder();
        builder.eq("id", id);
        return uniqueResult(builder);
    }

    @Override
    public List<Integer> distinctOrgId() {
        final List<Integer> list = new ArrayList<Integer>();

        String sql = "SELECT DISTINCT(org_id) FROM yunying.org_wechat_menu";

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();

        template.query(sql, params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                list.add(rs.getInt("org_id"));
                return 1;
            }
        });

        return list;
    }

    @Override
    public Map<String, String> mapKeyNameValueUrl(Integer orgId) {
        final Map<String, String> map = new HashMap<String, String>();

        String sql = "SELECT * FROM yunying.org_wechat_menu WHERE org_id=:orgId";

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", orgId);

        template.query(sql, params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                map.put(rs.getString("name"), rs.getString("url"));
                return 1;
            }
        });

        return map;
    }

}
