/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.wechat.dao.OrgWechatFansSummaryDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatFansSummary;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

@Repository
public class OrgWechatFansSummaryDaoImpl extends JdbcTemplateDaoSupport<OrgWechatFansSummary> implements OrgWechatFansSummaryDao{

	public OrgWechatFansSummaryDaoImpl() {
		super(OrgWechatFansSummary.class);
	}

	
	@Override
	public Map<String, OrgWechatFansSummary> mapKeyDateValueFansSummary(String authorizerAppId, Date beginDate, Date endDate, final SimpleDateFormat sdf) {
		final Map<String, OrgWechatFansSummary> map = new HashMap<String, OrgWechatFansSummary>();
		SimpleDateFormat dateSdf = new SimpleDateFormat("yyyy-MM-dd");
		String sql = "SELECT * FROM yunying.org_wechat_statistics_fans_summary WHERE authorizer_app_id=:authorizerAppId AND ref_date>=:beginDate AND ref_date<=:endDate";
		
        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String,Object>();
        params.put("authorizerAppId", authorizerAppId);
        params.put("beginDate", dateSdf.format(beginDate) );
        params.put("endDate", dateSdf.format(endDate) );
        
        template.query(sql, params, new RowMapper<Integer>() {
        	OrgWechatFansSummary fansSummary = null;
        	
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
            	fansSummary = new OrgWechatFansSummary();
            	fansSummary.setAuthorizerAppId( rs.getString("authorizer_app_id"));
            	fansSummary.setCancelUser( rs.getInt("cancel_user") );
            	fansSummary.setCreateTime( rs.getTimestamp("create_time") );
            	fansSummary.setId( rs.getInt("id") );
            	fansSummary.setNewUser( rs.getInt("new_user") );
            	fansSummary.setRefDate( rs.getDate("ref_date") );
            	map.put( sdf.format(fansSummary.getRefDate()), fansSummary);
                return 1;
            }
        });
        
        return map;
	}

}

