/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import com.baijia.tianxiao.dal.wechat.dao.OrgWechatCustomMenuDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatCustomMenu;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/**
 * @title : OrgWechatCustomMenuDaoImpl
 * @description :
 * @author : zhenyujian
 * @date : 2016年1月9日 上午10:52:51
 */
@Repository
public class OrgWechatCustomMenuDaoImpl extends JdbcTemplateDaoSupport<OrgWechatCustomMenu>
    implements OrgWechatCustomMenuDao {

    public OrgWechatCustomMenuDaoImpl() {
        super(OrgWechatCustomMenu.class);
    }

    @Override
    public OrgWechatCustomMenu getByAuthorizerAppId(String authorizerAppId) {
        SingleSqlBuilder<OrgWechatCustomMenu> builder = createSqlBuilder();
        builder.eq("authorizerAppId", authorizerAppId);
        return uniqueResult(builder);
    }

    @Override
    public List<String> OrgIdsHasWechatMenu() {
        String sql = "select authorizer_app_id from yunying.org_wechat_custom_menu";
        return this.getNamedJdbcTemplate().query(sql, new ResultSetExtractor<List<String>>() {

            @Override
            public List<String> extractData(ResultSet rs) throws SQLException, DataAccessException {
                List<String> appIds = new ArrayList<>();
                while (rs.next()) {
                    String appId = rs.getString("authorizer_app_id");
                    appIds.add(appId);
                }
                return appIds;
            }
        });

    }

}
