/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import com.baijia.tianxiao.dal.wechat.dao.FansDao;
import com.baijia.tianxiao.dal.wechat.po.Fans;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @title : FansDaoImpl
 * @description :
 * @author : zhenyujian
 * @date : 2015年12月8日 上午1:44:16
 */
@Repository
public class FansDaoImpl extends JdbcTemplateDaoSupport<Fans> implements FansDao {

    public FansDaoImpl() {
        super(Fans.class);
    }

    @Override
    public Fans getByOpenId(String openId) {
        SingleSqlBuilder<Fans> builder = createSqlBuilder();
        builder.eq("openId", openId);
        return uniqueResult(builder);
    }

    @Override
    public List<Fans> search(String authorizerAppId, String searchText, PageDto pageDto) {
        final List<Fans> list = new ArrayList<Fans>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM yunying.org_wechat_fans WHERE authorizer_app_id=:authorizerAppId ");
        if (StringUtils.isNotBlank(searchText)) {
            builder.append(" AND IF(remark!='',remark,nick) LIKE :searchText");
        }
        builder.append(" ORDER BY last_communication_time DESC, subscribe_time DESC");
        if (pageDto != null) {
            builder.append(" LIMIT :start,:size");
        }

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("authorizerAppId", authorizerAppId);
        params.put("searchText", "%" + searchText + "%");
        if (pageDto != null) {
            params.put("start", pageDto.firstNum());
            params.put("size", pageDto.getPageSize());
        }

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            Fans fans;

            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                fans = new Fans();
                fans.setAuthorizerAppId(rs.getString("authorizer_app_id"));
                fans.setCity(rs.getString("city"));
                fans.setCountry(rs.getString("country"));
                fans.setCreateTime(rs.getTimestamp("create_time"));
                fans.setGroupId(rs.getInt("groug_id"));
                fans.setHeadImgUrl(rs.getString("head_img_url"));
                fans.setId(rs.getInt("id"));
                fans.setIsDel(rs.getInt("is_del"));
                fans.setLanguage(rs.getString("language"));
                fans.setLastCommunicationTime(rs.getTimestamp("last_communication_time"));
                fans.setNick(rs.getString("nick"));
                fans.setOpenId(rs.getString("open_id"));
                fans.setProvince(rs.getString("province"));
                fans.setRemark(rs.getString("remark"));
                fans.setSex(rs.getInt("sex"));
                fans.setSubscribe(rs.getInt("subscribe"));
                fans.setSubscribeTime(rs.getTimestamp("subscribe_time"));
                fans.setUpdateTime(rs.getTimestamp("update_time"));
                fans.setHeadImgUrlGsx(rs.getString("head_img_url_gsx"));
                list.add(fans);
                return 1;
            }
        });

        return list;
    }

    @Override
    public Integer count(String authorizerAppId) {
        SingleSqlBuilder<Fans> builder = createSqlBuilder();
        builder.eq("authorizerAppId", authorizerAppId);
        builder.count("id");
        return queryForObject(builder, Integer.class);
    }

    @Override
    public Map<String, Integer> checkOpenIdExist(List<String> openIds) {
        final Map<String, Integer> map = new HashMap<String, Integer>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT id,open_id FROM yunying.org_wechat_fans WHERE open_id IN(:openIds)");

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("openIds", openIds);

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                map.put(rs.getString("open_id"), rs.getInt("id"));
                return 1;
            }
        });

        return map;
    }

    @Override
    public Integer countSubscribe(String authorizerAppId) {
        SingleSqlBuilder<Fans> builder = createSqlBuilder();
        builder.eq("authorizerAppId", authorizerAppId);
        builder.eq("subscribe", 1);
        builder.count("id");
        return queryForObject(builder, Integer.class);
    }

    @Override
    public Map<String, Fans> mapKeyOpenIdValueFans(List<String> openIds) {
        final Map<String, Fans> map = new HashMap<String, Fans>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM yunying.org_wechat_fans WHERE open_id IN(:openIds)");

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("openIds", openIds);

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            Fans fans;

            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                fans = new Fans();
                fans.setAuthorizerAppId(rs.getString("authorizer_app_id"));
                fans.setCity(rs.getString("city"));
                fans.setCountry(rs.getString("country"));
                fans.setCreateTime(rs.getTimestamp("create_time"));
                fans.setGroupId(rs.getInt("groug_id"));
                fans.setHeadImgUrl(rs.getString("head_img_url"));
                fans.setId(rs.getInt("id"));
                fans.setIsDel(rs.getInt("is_del"));
                fans.setLanguage(rs.getString("language"));
                fans.setLastCommunicationTime(rs.getTimestamp("last_communication_time"));
                fans.setNick(rs.getString("nick"));
                fans.setOpenId(rs.getString("open_id"));
                fans.setProvince(rs.getString("province"));
                fans.setRemark(rs.getString("remark"));
                fans.setSex(rs.getInt("sex"));
                fans.setSubscribe(rs.getInt("subscribe"));
                fans.setSubscribeTime(rs.getTimestamp("subscribe_time"));
                fans.setUpdateTime(rs.getTimestamp("update_time"));
                fans.setHeadImgUrlGsx(rs.getString("head_img_url_gsx"));
                map.put(fans.getOpenId(), fans);
                return 1;
            }
        });

        return map;
    }

    public Map<String, Integer> fansTotaByAppIds(List<String> appIds, Date startDate, Date endDate) {
        Map<String, Object> param = new HashMap<>();
        param.put("appIds", appIds);
        String sql =
            "select authorizer_app_id, count(id) count from yunying.org_wechat_fans where authorizer_app_id in (:appIds)";
        if (GenericsUtils.notNullAndEmpty(startDate) && GenericsUtils.notNullAndEmpty(endDate)) {
            sql += " and create_time between :startDate and :endDate";
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        sql += " group by authorizer_app_id";

        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<String, Integer>>() {

            @Override
            public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<String, Integer> map = new HashMap<>();
                while (rs.next()) {
                    String appId = rs.getString("authorizer_app_id");
                    Integer count = rs.getInt("count");
                    map.put(appId, count);
                }
                return map;
            }
        });

    }

    @Override
    public Map<String, Integer> getOrgWechatAuthorizerOfStudentTotal(List<String> appIds, Integer subscribe,
        Date startDate, Date endDate) {
        Map<String, Object> param = new HashMap<>();
        param.put("appIds", appIds);
        param.put("subscribe", subscribe);
        String sql =
            "select authorizer_app_id, count(id) count from yunying.org_wechat_fans where authorizer_app_id in (:appIds) and subscribe = :subscribe ";

        if (GenericsUtils.notNullAndEmpty(startDate) && GenericsUtils.notNullAndEmpty(endDate)) {
            sql += " and subscribe_time between :startDate and :endDate";
            param.put("startDate", startDate);
            param.put("endDate", endDate);
        }
        sql += " group by authorizer_app_id";

        return this.getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<String, Integer>>() {

            @Override
            public Map<String, Integer> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<String, Integer> map = new HashMap<>();
                while (rs.next()) {
                    String appId = rs.getString("authorizer_app_id");
                    Integer count = rs.getInt("count");
                    map.put(appId, count);
                }
                return map;
            }
        });

    }

	@Override
	public List<Fans> listFansWhichGxsImgIsNull(String authorizerAppId,PageDto page) {
		final List<Fans> list= new ArrayList<Fans>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM yunying.org_wechat_fans WHERE head_img_url_gsx='' ");
        
        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        if(StringUtils.isNotBlank(authorizerAppId)){
        	builder.append(" AND authorizer_app_id=:authorizerAppId");
        	params.put("authorizerAppId", authorizerAppId);
        }
        
        if(page!=null){
        	builder.append(" limit :start,:size");
        	params.put("start", (page.getPageNum()-1)*page.getPageSize());
        	params.put("size", page.getPageSize());
        }
        

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            Fans fans;

            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                fans = new Fans();
                fans.setId(rs.getInt("id"));
                fans.setAuthorizerAppId(rs.getString("authorizer_app_id"));
                fans.setHeadImgUrl(rs.getString("head_img_url"));
                fans.setHeadImgUrlGsx(rs.getString("head_img_url_gsx"));
                list.add(fans);
                return 1;
            }
        });

        return list;
	}

	@Override
	public List<Fans> listFansWhichGxsImgIsNull(String authorizerAppId, PageDto page, Long minId, Long maxId) {
		final List<Fans> list= new ArrayList<Fans>();

        StringBuilder builder = new StringBuilder();
        builder.append("SELECT * FROM yunying.org_wechat_fans WHERE head_img_url_gsx='' ");
        
        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        if(StringUtils.isNotBlank(authorizerAppId)){
        	builder.append(" AND authorizer_app_id=:authorizerAppId");
        	params.put("authorizerAppId", authorizerAppId);
        }
        
        if(StringUtils.isNotBlank(authorizerAppId)){
        	builder.append(" AND id>:minId");
        	params.put("minId", minId);
        }
        
        if(StringUtils.isNotBlank(authorizerAppId)){
        	builder.append(" AND id<:maxId");
        	params.put("maxId", maxId);
        }
        
        if(page!=null){
        	builder.append(" limit :start,:size");
        	params.put("start", (page.getPageNum()-1)*page.getPageSize());
        	params.put("size", page.getPageSize());
        }
        

        template.query(builder.toString(), params, new RowMapper<Integer>() {
            Fans fans;

            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                fans = new Fans();
                fans.setId(rs.getInt("id"));
                fans.setAuthorizerAppId(rs.getString("authorizer_app_id"));
                fans.setHeadImgUrl(rs.getString("head_img_url"));
                fans.setHeadImgUrlGsx(rs.getString("head_img_url_gsx"));
                list.add(fans);
                return 1;
            }
        });

        return list;
	}

	@Override
	public Integer batchUpdateFansToUnSubscribe(String authorizerAppId, Collection<String> subscribeList, Date listGetTime) {  
		if(CollectionUtils.isEmpty(subscribeList)){
			return 0;
		}
		
		String sql = "UPDATE yunying.org_wechat_fans SET subscribe=0 WHERE authorizer_app_id=:authorizerAppId AND create_time<:listGetTime AND open_id NOT IN (:subscribeList)";
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("authorizerAppId", authorizerAppId);
		params.put("listGetTime", listGetTime);
		params.put("subscribeList", subscribeList);
		
		NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
		return template.update(sql, params);
	}

	@Override
	public List<String> listOpenIds(String authorizerAppId) {
		NamedParameterJdbcTemplate template = getNamedJdbcTemplate(); 
		
		String sql = "SELECT open_id FROM yunying.org_wechat_fans WHERE authorizer_app_id=:authorizerAppId";
		Map<String, Object> params = new HashMap<String, Object>();
		params.put("authorizerAppId", authorizerAppId);
		
		return template.query(sql, params, new RowMapper<String>() {
            @Override
            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString("open_id");
            }
        });
	}

}
