/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.dao.impl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.stereotype.Repository;

import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.UnifiedWechatAccountDao;
import com.baijia.tianxiao.dal.wechat.po.AuthorizationInfo;
import com.baijia.tianxiao.dal.wechat.po.UnifiedWechatAccount;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

import lombok.extern.slf4j.Slf4j;

/**
 * @title : AuthorizationInfoDaoImpl
 * @description :
 * @author : zhenyujian
 * @date : 2015年12月5日 下午4:21:41
 */
@Repository("tianxiao_dal_yunying_authorizationInfoDao")
@Slf4j
public class AuthorizationInfoDaoImpl extends JdbcTemplateDaoSupport<AuthorizationInfo>
    implements AuthorizationInfoDao {

    @Autowired
    private UnifiedWechatAccountDao unifiedWechatAccountDao;

    public AuthorizationInfoDaoImpl() {
        super(AuthorizationInfo.class);
    }

    @Override
    public void deleteByOrgId(Integer orgId) {
        Map<String, Object> condition = new HashMap<String, Object>();
        condition.put("orgId", orgId);
        delByCondition(condition);
    }

    @Override
    public void deleteByAuthorizerAppId(String authorizerAppId) {
        Map<String, Object> condition = new HashMap<String, Object>();
        condition.put("authorizerAppId", authorizerAppId);
        delByCondition(condition);
    }

    // TODO 分校区统一公众号
    @Override
    public AuthorizationInfo getByOrgId(Integer orgId) {
        return this.getByOrgId(orgId, true);
    }

    @Override
    public AuthorizationInfo getByOrgId(Integer orgId, boolean withMasterSearch) {
        SingleSqlBuilder<AuthorizationInfo> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        AuthorizationInfo uniqueResult = uniqueResult(builder);
        if (uniqueResult == null && withMasterSearch) {
            UnifiedWechatAccount orgIdOfMaster =
                this.unifiedWechatAccountDao.findMasterAccountWithAnyCampusOrgId(orgId, true);
            log.info("UnifiedWechatAccount is :{} ", orgIdOfMaster);
            if (orgIdOfMaster != null) {
                uniqueResult = this.getByOrgId(orgIdOfMaster.getOrgId().intValue(), false);
                if (uniqueResult != null) {
                    uniqueResult.setOrgId(orgId);
                    uniqueResult.setOrgWechatType(1);
                    uniqueResult.setMasterOrgId(orgIdOfMaster.getOrgId().intValue());
                }
            }
        }
        return uniqueResult;
    }

    @Override
    public AuthorizationInfo getByAuthorizerAppId(String authorizerAppId) {
        SingleSqlBuilder<AuthorizationInfo> builder = createSqlBuilder();
        builder.eq("authorizerAppId", authorizerAppId);
        return uniqueResult(builder);
    }

    @Override
    public Map<Long, String> mapAppIdByorgId(List<Long> orgIds) {
        final Map<Long, String> map = new HashMap<Long, String>();

        String sql = "SELECT * FROM yunying.org_wechat_authorization_info WHERE org_id IN (:orgIds)";

        NamedParameterJdbcTemplate template = getNamedJdbcTemplate();
        Map<String, Object> params = new HashMap<String, Object>();
        params.put("orgIds", orgIds);

        template.query(sql, params, new RowMapper<Integer>() {
            @Override
            public Integer mapRow(ResultSet rs, int rowNum) throws SQLException {
                map.put(rs.getLong("org_id"), rs.getString("authorizer_app_id"));
                return 1;
            }
        });

        for (Long orgId : orgIds) {
            String appId = map.get(orgId);
            if (GenericsUtils.isNullOrEmpty(appId)) {
                AuthorizationInfo byOrgId = this.getByOrgId(orgId.intValue(), true);
                if (byOrgId != null) {
                    map.put(orgId, byOrgId.getAuthorizerAppId());
                }
            }

        }

        return map;
    }

}
