
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.wechat.dao;

import java.util.Collection;
import java.util.List;

import com.baijia.tianxiao.dal.wechat.po.UnifiedWechatAccount;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @say little Boy, don't be sad.
 * @name Rezar
 * @time Nov 21, 2016
 * @Desc this guy is too lazy, nothing left.
 */

public interface UnifiedWechatAccountDao extends CommonDao<UnifiedWechatAccount> {

    /**
     * 根据纳入统一公众号管理范围里面的任何一个分校区机构的信息获取全部分校区的信息
     * 
     * @param orgNumber
     * @param isOrgId 是否根据orgId作为标示符 true:orgId , flase:orgNumber
     * @return
     */
    public List<UnifiedWechatAccount> listAllCampusWithAnyOneOrgInfo(Long orgId, boolean isOrgId);

    /**
     * 判断某个机构是否是统一公众号的分校区
     * 
     * @param orgId
     * @param isOrgId 是否根据orgId作为标示符 true:orgId , flase:orgNumber
     * @return
     */
    public UnifiedWechatAccount findUnifiedWechatRecord(Long orgId, boolean isOrgId, Integer delStatus);

    /**
     * 根据orgId删除某个分校区的记录(软删除)
     * 
     * @param orgId
     */
    public void deleteByOrgId(Long orgId);

    /**
     * @param ordIds
     * @param isOrgId
     * @param delStatus
     * @return
     */
    List<UnifiedWechatAccount> findUnifiedWechatRecords(Collection<Long> ordIds, boolean isOrgId, Integer delStatus);

    /**
     * @param orgId
     * @param isInit
     * @return
     */
    public UnifiedWechatAccount findMasterAccountWithAnyCampusOrgId(Integer orgId, Boolean isInit);

    /**
     * @param slaveCampusOrgId
     */
    void deleteSlaveCampusByOrgId(Long slaveCampusOrgId);

    /**
     * 
     * 对当前统一公众号校区的账号进行处理,如果发现当前的校区内只剩下总校区,则将总校区置为普通校区
     * 
     * @param masterOrgId
     */
    public boolean resetOrgWechatTypeIfNecessary(Integer masterOrgId);

}
