/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.constant;

import java.util.Map;

import com.google.common.collect.Maps;

/**
 * @title WechatPermission
 * @desc TODO
 * @author wangzhigang
 * @date 2015年7月22日
 * @version 1.0
 */
public enum WechatSubscribe {

	UNSUBSCIRBE(0, "未关注"), //
    SUBSCIRBE(1, "已关注"), //
    ; //

    private static Map<Integer, String> map = Maps.newHashMap();

    static {
        for (WechatSubscribe p : values()) {
            map.put(p.getValue(), p.getNote());
        }
    }

    private int value;
    private String note;

    private WechatSubscribe(int value, String note) {
        this.value = value;
        this.note = note;
    }

    public int getValue() {
        return this.value;
    }

    public String getNote() {
        return this.note;
    }

    public static String getNote(Integer value) {
        return map.get(value);
    }
}
