/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.constant;

import java.util.Map;

import com.google.common.collect.Maps;

/**   
 * @title       : WechatPermission 
 * @description : https://open.weixin.qq.com/cgi-bin/showdocument?action=dir_list&t=resource/res_list&verify=1&id=open1419318587&token=&lang=zh_CN 
 * @author      : zhenyujian
 * @date        : 2015年12月16日 上午11:18:00 
 */
public enum WechatPermission {

    MESSAGE_AND_MENU     (1, "消息与菜单权限集"), 
    USER_MANAGE          (2, "用户管理权限集"), 
    ACCOUNT_MANAGE       (3, "帐号管理权限集"), 
    PAGE_AUTHORIZE       (4, "网页授权权限集"), 
    WECHAT_SHOP          (5, "微信小店权限集"), 
    MULTI_CUSTOMER_SERVIE(6, "多客服权限集"), 
    BUSINESS_NOTIFY      (7, "业务通知权限集"), 
    WECHAT_CARD          (8, "微信卡券权限集"),
    WECHAT_SCAN          (9, "微信扫一扫权限集"),
    WECHAT_WIFY          (10,"微信连WIFI权限集"),
    WECHAT_MEDIA         (11,"素材管理权限集"),
    WECHAT_SHAKE         (12,"摇一摇周边权限集"),
    WECHAT_STORE         (13,"微信门店权限集"),
    ; 
    
    

    private static Map<Integer, String> map = Maps.newHashMap();

    static {
        for (WechatPermission p : values()) {
            map.put(p.getValue(), p.getNote());
        }
    }

    private int value;
    private String note;

    private WechatPermission(int value, String note) {
        this.value = value;
        this.note = note;
    }

    public int getValue() {
        return this.value;
    }

    public String getNote() {
        return this.note;
    }

    public static String getNote(Integer value) {
        return map.get(value);
    }
}
