/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.constant;

import java.util.Map;

import com.google.common.collect.Maps;

/**   
 * @title       : WechatAppVerifyType 
 * @description : 微信公众号 认证状态
 * 				  http://mp.weixin.qq.com/wiki/8/71e1908fa08e67c6251ebdd78fd6b6b4.html
 * @author      : zhenyujian
 * @date        : 2015年12月16日 上午10:40:54 
 */
public enum WechatAppVerifyType {

	//1、微博认证视作未认证,因此微博认证的公众号不会拥有微信认证公众号特有的接口。
	//2、微信认证分为资质认证和名称认证两部分，只需要资质认证通过，就可获得接口。
	
	NOT_VERIFY(-1, "未认证"),
	WECHAT_VERIFY(0, "微信认证"),
	SINA_WEIBO_VERIFY(1, "新浪微博认证"),
	TENNCENT_WEIBO_VERIFY(2, "腾讯微博认证"),
	QUAL_VERIFY_WITHOUT_NAME(3, "已资质认证通过但还未通过名称认证"),
	QUAL_SINA_WEIBO_VERIFY_WITHOUT_NAME(4, "已资质认证通过、还未通过名称认证，但通过了新浪微博认证"),
	QUAL_TENCENT_WEIBO_VERIFY_WITHOUT_NAME(5, "已资质认证通过、还未通过名称认证，但通过了腾讯微博认证"),
	;
	
    private static Map<Integer, String> map = Maps.newHashMap();

    static {
        for (WechatAppVerifyType p : values()) {
            map.put(p.getValue(), p.getNote());
        }
    }

    private int value;
    private String note;

    private WechatAppVerifyType(int value, String note) {
        this.value = value;
        this.note = note;
    }

    public int getValue() {
        return this.value;
    }
    public String getNote() {
        return this.note;
    }
    public static String getNote(Integer value) {
        return map.get(value);
    }
    
    
    public static boolean isPassedVerify(Integer value){
    	//1、微博认证视作未认证,因此微博认证的公众号不会拥有微信认证公众号特有的接口。
    	//2、微信认证分为资质认证和名称认证两部分，只需要资质认证通过，就可获得接口。
    	if( value.intValue()==WECHAT_VERIFY.getValue()
    	  ||value.intValue()==QUAL_VERIFY_WITHOUT_NAME.getValue()
    	  ||value.intValue()==QUAL_SINA_WEIBO_VERIFY_WITHOUT_NAME.getValue()
    	  ||value.intValue()==QUAL_TENCENT_WEIBO_VERIFY_WITHOUT_NAME.getValue()){
    		return true;
    	}
    	return false;
    }
}