/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.wechat.constant;

import java.util.Map;

import com.google.common.collect.Maps;

/**   
 * @title       : WechatAppServiceType 
 * @description : 微信公众号类型
 * @author      : zhenyujian
 * @date        : 2015年12月16日 上午10:40:37 
 */
public enum WechatAppServiceType {

	SUBSCRIBE_APP(0, "订阅号"),
	SUBSCRIBE_APP_FROM_OLD(1, "由历史老帐号升级后的订阅号"),
	SERVICE_APP(2, "服务号"),
	
    ;

    private static Map<Integer, String> map = Maps.newHashMap();

    static {
        for (WechatAppServiceType p : values()) {
            map.put(p.getValue(), p.getNote());
        }
    }

    private int value;
    private String note;

    private WechatAppServiceType(int value, String note) {
        this.value = value;
        this.note = note;
    }

    public int getValue() {
        return this.value;
    }

    public String getNote() {
        return this.note;
    }

    public static String getNote(Integer value) {
        return map.get(value);
    }
    
    public static boolean isServiceApp(Integer value){
    	if( value.intValue()==SERVICE_APP.getValue()){
    		return true;
    	}
    	return false;
    }
}