
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.upload.po;

import java.util.Date;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import lombok.Data;

/**
 * @title TxUploadRecords
 * @desc 天校的上传记录
 * @author cxm
 * @date 2016年3月15日
 * @version 1.0
 */
@Entity(name = "tx_upload_records")
@Table(catalog = "yunying")
@Data
public class TxUploadRecords {

    @Id
    @GeneratedValue
    private Integer id;

    @Column
    private Long orgId;

    @Column
    private int uploadType;

    @Column
    private String fileName;

    @Column
    private int totalCount;

    @Column
    private int successCount;

    @Column
    private int repeatCount;

    @Column
    private int failCount;

    @Column
    private int status;

    @Column
    private String errorFileUrl;

    @Column
    private Date createTime;

    @Column
    private Date updateTime;

}
