/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.todo.po;

import java.util.Date;

import lombok.Data;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

@Entity(name = "tx_backlog_participants")
@Table(catalog = "yunying")
@Data
public class TxbacklogParticipant {
	
 	@Id
    @GeneratedValue
    @Column
    private Long id;

    @Column(name = "backlog_id")
    private Long backlogId;

    @Column(name = "org_id")
    private Long orgId;
    
    // 参与人id
    @Column(name = "cascade_id")
    private Long cascadeId;
    
    @Column(name = "finish")
    private Integer finish;

    @Column(name = "create_time")
	private Date createTime;
    
    @Column(name = "update_time")
	private Date updateTime;
    
    @Column(name = "del_status")
    private Integer delStatus;
    
    public TxbacklogParticipant(){
    }
    
    public TxbacklogParticipant(Long backlogId, Long orgId, Long cascadeId){
    	this.orgId = orgId;
    	this.backlogId = backlogId;
    	this.cascadeId = cascadeId;
    	this.finish = 0;
    	this.delStatus = 0;
    }
    
}
