
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.todo.dao;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.baijia.tianxiao.constant.OrderBy;
import com.baijia.tianxiao.dal.todo.po.TxBacklog;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

/**
 * @title TxBacklogDao
 * @desc TODO
 * @author zhangbing
 * @date 2016年2月25日
 * @version 1.0
 */

public interface TxBacklogDao extends CommonDao<TxBacklog> {

    /**
     * 待办事项提醒
     * 
     * @param startTime
     * @param endTime
     * @return
     */
    public List<TxBacklog> getBacklogListByRemindTime(Date startTime, Date endTime);

    /**
     * 根据分组获取待办事项列表
     * 
     * @param orgId 机构id
     * @param groupType 分组类型:GroupType
     * @return
     */
    public List<TxBacklog> getBacklogListByGroup(final Long orgId, Integer txCascadeId, final Integer groupType,
        final PageDto page, final String...queryProps);

    /**
     * 根据id和orgId获取待办事项详情
     * 
     * @param id 待办事项id
     * @param orgId 机构id
     * @return
     */
    public TxBacklog getBacklogByIdAndOrgId(Long id, Long orgId, String...queryProps);

    /**
     * 根据consulterId和orgId获取系统待办事项(未过期的系统待办事项唯一)
     * 
     * @param consulterId 咨询用户id
     * @param orgId 机构id
     * @param expired 是否过期:true,已过期; false,未过期; null,不判断是否过期
     * @return
     */
    public List<TxBacklog> getBacklogByConsulterIdAndOrgId(Long consulterId, Long orgId, Boolean expired,
        String...queryProps);

    /**
     * 根据studentId和orgId获取系统待办事项(未过期的系统待办事项唯一)
     * 
     * @param studentId 正式学员id
     * @param orgId 机构id
     * @param expired 是否过期:true,已过期; false,未过期; null,不判断是否过期
     * @return
     */
    public List<TxBacklog> getBacklogByStudentIdAndOrgId(Long studentId, Long orgId, Boolean expired,
        String...queryProps);

    /**
     * 使用今日待办的所有机构
     */
    public List<Long> getExistOrgIds();

    /**
     * 今日待办总数量数量
     */
    public Map<Long, Integer> getBacklogTotal(Date startTime, Date endTime, List<Long> TianxiaoOrgIds);

    /**
     * 查询截止到当前已完成的待办总数
     */
    public Map<Long, Integer> getBacklogFinish(List<Long> TianxiaoOrgIds);

    /**
     * 查询今日待办过期数量
     */
    public Map<Long, Integer> getBacklogExpired(Date startTime, Date endTime, List<Long> TianxiaoOrgIds);

    public List<TxBacklog> list(List<Long> idList, Integer pageNum, Integer pageSize, Date minEndTime, Date maxEndTime, OrderBy orderByEndTime);
    
    public void consultConvertToStu(Long consultUserId, Long studentId);
    
    List<Long> listExpiredBacklogId(Long orgId, Date expiredTime);
    
    
}
