package com.baijia.tianxiao.dal.todo.constant;


public enum BacklogStatus {
    UNKNOWN(-1,"未知"), UNEXPIRED(0,"待办"),EXPIRED(1,"过期");
  
    int value;
    String note;
    
    private BacklogStatus(int value, String note){
        this.value = value;
        this.note = note;
    }
    
    public int getValue(){
        return this.value;
    }
    
    public String getNote(){
        return this.note;
    }
    
    public static String getNoteByValue(int value) {
        String note = null;
        for(BacklogStatus status : values()) {
            if(status.getValue() == value) {
                note = status.getNote();
                break;
            }
        }
        return note;
    }
}

