/**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.sync.po;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;

import java.util.Date;

import lombok.Data;

/**
 * @author gaodan
 * @createdate 2016年10月13日
 * @desc 按天统计用户来源(访客、线索)
 */
@Data
@Entity(name = "tx_user_source_statistic_day")
@Table(catalog = "yunying")
public class TxUserSourceStatisticDay {
    @Id
    @GeneratedValue
    @Column
    private Long id;

    @Column(name = "consult_user_id")
    private Long consultUserId;

    @Column(name = "org_id")
    private Long orgId;

    @Column(name = "source_type")
    private Integer sourceType;

//    @Column(name = "user_type")
//    private Integer userType;   //与MsgUserRole保持一致 咨询:101 线索:102  用户首次访问时状态
    @Column(name = "number")
    private Integer number;
    
    @Column(name = "visit_date")
    private Date visitDate;  //用户以某种身份首次访问时日期

    @Column(name = "create_time")
    private Date createTime;

    @Column(name = "update_time")
    private Date updateTime;
    
}
