package com.baijia.tianxiao.dal.sync.dao.impl;

import com.baijia.tianxiao.dal.sync.dao.TxOrgCourseStatHourDao;
import com.baijia.tianxiao.dal.sync.po.TxOrgCourseStatHour;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.google.common.base.Preconditions;
import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * Created by wengshengli on 15/12/22.
 */
@Repository
public class TxOrgCourseStatHourDaoImpl extends JdbcTemplateDaoSupport<TxOrgCourseStatHour> implements TxOrgCourseStatHourDao {

    public TxOrgCourseStatHourDaoImpl() {
        super(TxOrgCourseStatHour.class);
    }


    @Override
    public List<TxOrgCourseStatHour> getListByMinId(Long minId, Date lastDate, int maxSize, String... queryProps) {
        Preconditions.checkArgument(maxSize > 0, "maxSize is illegal");
        SingleSqlBuilder<TxOrgCourseStatHour> builder = createSqlBuilder(queryProps);
        if (minId == null) {
            minId = 0l;
        }
        builder.gt("id", minId);
        builder.setMaxSize(maxSize);
        return queryList(builder);
    }
}
