package com.baijia.tianxiao.dal.sync.dao.impl;

import com.baijia.tianxiao.dal.sync.dao.TxOrgCourseStatDao;
import com.baijia.tianxiao.dal.sync.po.TxOrgCourseStat;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * Created by wengshengli on 15/12/22.
 */
@Repository
public class TxOrgCourseStatDaoImpl extends JdbcTemplateDaoSupport<TxOrgCourseStat> implements TxOrgCourseStatDao {

    public TxOrgCourseStatDaoImpl() {
        super(TxOrgCourseStat.class);
    }


    @Override
    public TxOrgCourseStat getOrgAndCourseNumber(Long orgNumber, Long courseNumber, String... queryProp) {
        SingleSqlBuilder<TxOrgCourseStat> builder = createSqlBuilder(queryProp);
        builder.eq("orgNumber", orgNumber);
        builder.eq("courseNumber", courseNumber);
        return uniqueResult(builder);
    }

    @Override
    public List<TxOrgCourseStat> listTop5ByOrg(Long orgNumber, String... queryProp) {
        SingleSqlBuilder<TxOrgCourseStat> builder = createSqlBuilder(queryProp);
        builder.eq("orgNumber", orgNumber);
        builder.desc("pv");
        builder.setMaxSize(5);

        return queryList(builder);
    }
}
