package com.baijia.tianxiao.dal.sync.dao.impl;

import com.baijia.tianxiao.dal.sync.dao.TxMonitorTypeDayDao;
import com.baijia.tianxiao.dal.sync.po.TxMonitorTypeDay;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by wengshengli on 15/12/29.
 */
@Repository
@Slf4j
public class TxMonitorTypeDayDaoImpl extends JdbcTemplateDaoSupport<TxMonitorTypeDay> implements TxMonitorTypeDayDao {
    public TxMonitorTypeDayDaoImpl() {
        super(TxMonitorTypeDay.class);
    }

    @Override
    public List<TxMonitorTypeDay> listTypeDay(Long orgNumber, Date startDate, Date endDate, String...queryProps) {
        SingleSqlBuilder<TxMonitorTypeDay> builder = createSqlBuilder(queryProps);

        builder.sum("pv", "pv");
        builder.sum("uv", "uv");
        builder.eq("orgNumber", orgNumber);
        builder.ge("mdate", startDate);
        builder.lt("mdate", endDate);
        builder.group("pageType");

        return queryList(builder, TxMonitorTypeDay.class);
    }

    @Override
    public List<TxMonitorTypeDay> listUseMonitorType(Date startDate, Date endDate, List<Integer> TianxiaoOrgNumbers) {
        SingleSqlBuilder<TxMonitorTypeDay> builder = createSqlBuilder();
        builder.sum("pv", "pv");
        builder.sum("uv", "uv");
        builder.in("orgNumber", TianxiaoOrgNumbers);
        builder.group("orgNumber");
        if (startDate != null && endDate != null) {
            builder.between("mdate", startDate, endDate);
        }
        return queryList(builder, TxMonitorTypeDay.class);
    }

    @Override
    public Map<String, TxMonitorTypeDay> mapUseMonitorType(Date startDate, Date endDate,
        List<Integer> TianxiaoOrgNumbers) {
        Map<String, Object> param = new HashMap<>();
        param.put("orgNumbers", TianxiaoOrgNumbers);
        param.put("startDate", startDate);
        param.put("endDate", endDate);
        String sql = "select sum(pv) pv, sum(uv) uv, DATE_FORMAT(mdate,'%y-%m-%d') 'mdate' from yunying.tx_monitor_type_day where org_number in (:orgNumbers) "
            + "and mdate between :startDate and :endDate group by MONTH(mdate),DAY(mdate)";
        
        return getNamedJdbcTemplate().query(sql, param, new ResultSetExtractor<Map<String, TxMonitorTypeDay>>() {

            @Override
            public Map<String, TxMonitorTypeDay> extractData(ResultSet rs) throws SQLException, DataAccessException {
                Map<String, TxMonitorTypeDay> map = new HashMap<>();
                while(rs.next()){
                    TxMonitorTypeDay txMonitorTypeDay = new TxMonitorTypeDay();
                    String date = rs.getString("mdate");
                    txMonitorTypeDay.setPv(rs.getInt("pv"));
                    txMonitorTypeDay.setUv(rs.getInt("uv"));
                    log.info("mdate===========" + rs.getString("mdate") + "count==========" + rs.getInt("pv"));
                    map.put(date, txMonitorTypeDay);
                }
                return map;
            }
        });
    }

}
