package com.baijia.tianxiao.dal.sync.dao.impl;

import com.baijia.tianxiao.dal.sync.dao.TxMonitorTodayMinDao;
import com.baijia.tianxiao.dal.sync.po.TxMonitorCourseDay;
import com.baijia.tianxiao.dal.sync.po.TxMonitorOrgDay;
import com.baijia.tianxiao.dal.sync.po.TxMonitorTodayMin;
import com.baijia.tianxiao.dal.sync.po.TxMonitorTypeDay;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.date.DateUtil;
import org.springframework.stereotype.Repository;

import java.util.List;


/**
 * Created by wengshengli on 15/12/26.
 */
@Repository
public class TxMonitorTodayMinDaoImpl extends JdbcTemplateDaoSupport<TxMonitorTodayMin> implements TxMonitorTodayMinDao {

    public TxMonitorTodayMinDaoImpl() {
        super(TxMonitorTodayMin.class);
    }


    @Override
    public TxMonitorTodayMin getByKey(Long orgNumber, int pageType, Long userNumber,String uuid, Long typeNumber, String... queryProps) {
        SingleSqlBuilder<TxMonitorTodayMin> builder = createSqlBuilder(queryProps);

        builder.eq("orgNumber", orgNumber);
        builder.eq("pageType", pageType);
        builder.eq("userNumber", userNumber);
        builder.eq("uuid", uuid);
        builder.eq("typeNumber", typeNumber);

        return uniqueResult(builder);
    }


    public boolean checkByOrgUser(Long orgNumber, Long userNumber,String uuid, List<Integer> pageTypeList, String... queryProps) {
        SingleSqlBuilder<TxMonitorTodayMin> builder = createSqlBuilder(queryProps);

        builder.count("id");
        builder.eq("orgNumber", orgNumber);
        builder.in("pageType", pageTypeList);
        builder.eq("userNumber", userNumber);
        builder.eq("uuid",uuid);
        builder.gt("mdate", DateUtil.getLastHourDate());

        int count = queryForObject(builder, Integer.class);
        return count > 0;
    }

    @Override
    public List<TxMonitorOrgDay> group2OrgDay(Long orgNumber, String... queryProps) {
        SingleSqlBuilder<TxMonitorTodayMin> builder = createSqlBuilder(queryProps);

        builder.select("mdate");
        builder.sum("pv", "pv");
        if (orgNumber != null) {
            builder.eq("orgNumber", orgNumber);
        }
        builder.groupByNames("orgNumber","userNumber","uuid");
        return queryList(builder, TxMonitorOrgDay.class);
    }

    @Override
    public List<TxMonitorTypeDay> group2TypeDay(Long orgNumber, String... queryProps) {
        SingleSqlBuilder<TxMonitorTodayMin> builder = createSqlBuilder(queryProps);

        builder.select("mdate");
        builder.sum("pv", "pv");
        builder.count("id", "uv");
        if (orgNumber != null) {
            builder.eq("orgNumber", orgNumber);
        }
        builder.groupByNames("orgNumber", "pageType","userNumber","uuid");
        return queryList(builder, TxMonitorTypeDay.class);
    }


    @Override
    public List<TxMonitorCourseDay> group2CourseDay(Long orgNumber, List<Integer> pageTypes, String... queryProps) {
        SingleSqlBuilder<TxMonitorTodayMin> builder = createSqlBuilder(queryProps);

        builder.select("pageType", "mdate");
        builder.selectAlias("typeNumber", "courseNumber");
        builder.sum("pv", "pv");
        builder.count("id", "uv");
        if (orgNumber != null) {
            builder.eq("orgNumber", orgNumber);
        }
        builder.in("pageType", pageTypes);
        builder.groupByNames("orgNumber", "typeNumber","userNumber","uuid");
        return queryList(builder, TxMonitorCourseDay.class);
    }

    @Override
    public List<Long> queryForIds(String... queryProps) {
        SingleSqlBuilder<TxMonitorTodayMin> builder = createSqlBuilder(queryProps);
        builder.select("id");
        return queryForList(builder, Long.class);
    }

    @Override
    public int countPvToday(long orgNumber, String... queryProps) {
        SingleSqlBuilder<TxMonitorTodayMin> builder = createSqlBuilder(queryProps);
        builder.sum("pv");
        builder.group("orgNumber");
        return queryForObject(builder, Integer.class);
    }
}
