package com.baijia.tianxiao.dal.sync.dao.impl;

import com.baijia.tianxiao.dal.sync.dao.TxMonitorCourseDayDao;
import com.baijia.tianxiao.dal.sync.po.TxMonitorCourseDay;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;

import org.springframework.stereotype.Repository;

import java.util.Date;
import java.util.List;

/**
 * Created by wengshengli on 15/12/29.
 */
@Repository
public class TxMonitorCourseDayDaoImpl extends JdbcTemplateDaoSupport<TxMonitorCourseDay> implements TxMonitorCourseDayDao {
    public TxMonitorCourseDayDaoImpl() {
        super(TxMonitorCourseDay.class);
    }

    @Override
    public List<TxMonitorCourseDay> top5CourseDay(Long orgNumber, Date startDate, Date endDate, String... queryProps) {
        SingleSqlBuilder<TxMonitorCourseDay> builder = createSqlBuilder(queryProps);

        builder.sum("pv","pv");
        builder.sum("uv","uv");
        builder.select("courseName", "pageType");
        builder.eq("orgNumber", orgNumber);
        builder.ge("mdate", startDate);
        builder.lt("mdate", endDate);
        builder.group("courseNumber");

        return queryList(builder, TxMonitorCourseDay.class);
    }
}
