package com.baijia.tianxiao.dal.sync.dao.impl;

import com.baijia.tianxiao.dal.sync.dao.TxConsultUserStatMonthDao;
import com.baijia.tianxiao.dal.sync.po.TxConsultUserStatMonth;
import com.baijia.tianxiao.sqlbuilder.SingleSqlBuilder;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.JdbcTemplateDaoSupport;
import com.baijia.tianxiao.util.GenericsUtils;

import com.google.common.collect.Maps;

import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.stereotype.Repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;

/**
 * Created by wengshengli on 15/12/11.
 */

@Repository
@Slf4j
public class TxConsultUserStatMonthDaoImpl extends JdbcTemplateDaoSupport<TxConsultUserStatMonth> implements TxConsultUserStatMonthDao {

    public TxConsultUserStatMonthDaoImpl() {
        super(TxConsultUserStatMonth.class);
    }

    @Override
    public int countByOrgConsultStatus(Long orgId, int status, int monthDiff) {

        Map<String, Object> params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("monthDiff", monthDiff);
        params.put("status", status);

        StringBuilder sb = new StringBuilder("select count(1) from (select count(1) from yunying.tx_consult_stat_month");
        sb.append(" where org_id = :orgId");
        sb.append(" and  date_format(create_time,'%Y-%m')=date_format(DATE_SUB(curdate(), INTERVAL :monthDiff MONTH),'%Y-%m') and status >=:status group by consult_user_id,user_id) a");

        log.info("countByOrgConsultStatus sql= {},params:{orgId={},monthDiff={},status={}}", sb.toString(), orgId, monthDiff, status);
        return getNamedJdbcTemplate().queryForObject(sb.toString(), params, Integer.class);
    }


    @Override
    public int countEnrolls(Long orgId, int status, Date startTime,Date endTime) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("status", status);
        params.put("startTime", startTime);
        params.put("endTime", endTime);
        StringBuilder sb = new StringBuilder("select count(1) from (select consult_user_id,user_id from yunying.tx_consult_stat_month");
        sb.append(" where org_id = :orgId");
        sb.append(" and create_time between :startTime and :endTime and status =:status group by consult_user_id,user_id) c");
        log.info("countByOrgConsultStatus sql= {},params:{orgId={},monthDiff={},status={}}", sb.toString(), orgId, status);
        return getNamedJdbcTemplate().queryForObject(sb.toString(), params, Integer.class);
    }
    
    @Override
    public List<TxConsultUserStatMonth> getPageTxConsultUserStatMonthByStatus(Long orgId, int status, Date startDate, Date endDate, PageDto pageDto) {
        Map<String, Object> params = Maps.newHashMap();
        params.put("orgId", orgId);
        params.put("status", status);
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        
        StringBuilder sb = new StringBuilder("select * from yunying.tx_consult_stat_month ");
        sb.append(" where org_id = :orgId");
        
        sb.append(" and create_time between :startDate and :endDate and status =:status group by consult_user_id,user_id");
        
        if(GenericsUtils.notNullAndEmpty(pageDto)){
            int start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
            int limit = pageDto.getPageSize();
            sb.append(" limit :start, :limit");
            params.put("start", start);
            params.put("limit", limit);
        }
        
        log.info("getPageTxConsultUserStatMonthByStatus sql= {},params:{orgId={}, startDate={}, endDate={}status={}}", sb.toString(), orgId, startDate, endDate, status);
        
        return this.getNamedJdbcTemplate().query(sb.toString(), params, new ResultSetExtractor<List<TxConsultUserStatMonth>>() {

            @Override
            public List<TxConsultUserStatMonth> extractData(ResultSet rs) throws SQLException, DataAccessException {
                List<TxConsultUserStatMonth> list = new ArrayList<>();
                while(rs.next()){
                    TxConsultUserStatMonth txConsultUserStatMonth = getInstance(rs);
                    list.add(txConsultUserStatMonth);
                }
                return list;
            }
        });
    }
    

    @Override
    public TxConsultUserStatMonth getTxConsultStatByQuery(long orgId, long consultUserId, long userId, Integer sourceType, Date startTime, Date endTime) {
        SingleSqlBuilder<TxConsultUserStatMonth> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        if (consultUserId != 0) {
            builder.eq("consultUserId", consultUserId);
        } else {
            builder.eq("userId", userId);
        }
        if(GenericsUtils.notNullAndEmpty(sourceType)){
            builder.eq("sourceType", sourceType);
        }
        builder.ge("createTime", startTime);
        builder.lt("createTime", endTime);
        builder.setMaxSize(1);
        builder.desc("createTime");

        return uniqueResult(builder);
    }

    @Override
    public int countByTime(long orgId, Date startTime, Date endTime) {
        SingleSqlBuilder<TxConsultUserStatMonth> builder = createSqlBuilder();
        builder.eq("orgId", orgId);
        builder.sum("number");
        builder.ge("updateTime", startTime);
        builder.lt("updateTime", endTime);
        builder.group("orgId");
        return queryForObject(builder, Integer.class);
    }
    
    private TxConsultUserStatMonth getInstance(ResultSet rs) throws SQLException, DataAccessException {
        TxConsultUserStatMonth txConsultUserStatMonth = new TxConsultUserStatMonth();
        txConsultUserStatMonth.setId(rs.getLong("id"));
        txConsultUserStatMonth.setConsultUserId(rs.getLong("consult_user_id"));
        txConsultUserStatMonth.setUserId(rs.getLong("user_id"));
        txConsultUserStatMonth.setOrgId(rs.getLong("org_id"));
        txConsultUserStatMonth.setStatus(rs.getInt("status"));
        txConsultUserStatMonth.setSourceType(rs.getInt("source_type"));
        txConsultUserStatMonth.setNumber(rs.getInt("number"));
        
        return txConsultUserStatMonth;
    }

}
