package com.baijia.tianxiao.dal.sync.dao;

import com.baijia.tianxiao.dal.sync.po.TxConsultUserStatMonth;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.sqlbuilder.support.CommonDao;

import java.util.Date;
import java.util.List;

/**
 * Created by wengshengli on 15/12/11.
 */
public interface TxConsultUserStatMonthDao extends CommonDao<TxConsultUserStatMonth> {

    /**
     * 统计本月招生人数
     * @param orgId
     * @param status
     * @param startTime
     * @param endTime
     * @return
     */
    public int countEnrolls(Long orgId, int status, Date startTime,Date endTime);

    /**
     * 机构咨询用户统计 根据状态,int monthDiff=0本月
     * monthDiff==1上月
     *
     * @param orgId
     * @return
     */
    int countByOrgConsultStatus(Long orgId, int status, int monthDiff);
    
    int countByTime(long orgId,Date startTime,Date endTime);

    TxConsultUserStatMonth getTxConsultStatByQuery(long orgId, long consultUserId, long userId, Integer sourceType, Date startTime, Date endTime);
    
    /**
     * 分页获取机构咨询用户 
     */
    List<TxConsultUserStatMonth> getPageTxConsultUserStatMonthByStatus(Long orgId, int status, Date startDate, Date endDate, PageDto pageDto);
    
}
