/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.dal.sync.constant;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author cxm
 * @version 1.0
 * @title MsgSyncType
 * @desc TODO
 * @date 2015年12月7日
 */
public enum MsgSyncType {
    /**
     * 机构400电话
     */
    ORG_CALL(1),

    /**
     * 预约咨询消息
     */
    ADVISORY(2),

    /**
     * 同步IM聊天的学生信息
     */
    IM_STU(3),

    /**
     * 添加机构学员
     */
    ADD_STU(4),

    /**
     * 购买课程
     */
    COURSE_PURCHASE(5),

    /**
     * 报名
     */
    SIGNUP_PURCHASE(6),

    /**
     * 咨询用户消息统计
     */
    CONSULT_MSG_STAT(7),

    /**
     * IM消息统计
     */
    CONSULT_IM_STAT(8),

    /**
     * 咨询用户统计
     */
    CONSULT_USER_STAT(9),

    /**
     * 报名用户统计
     */
    CONSULT_SIGNUP_STAT(10),

    /**
     * 3810成单用户统计
     */
    CONSULT_3810_PURCHASE_STAT(11),

    /**
     * 机构微课PV统计
     */
    STAT_ORG_COURSE_PV(12),

    /**
     * 网校首页PV统计
     */
    STAT_WX_INDEX_PV(13),

    /**
     * 课节学生添加默认评价
     */
    LESSON_STUDENT_DEFAULT_COMMENT(14),

    /**
     * 课节开始前学生老师消息通知
     */
    LESSON_BEGIN_SMS(15),

    /**
     * 评价统计
     */
    COMMENT_AUDIT(16),

    /**
     * 主站支付的微课同步到报名系统中
     */
    PAY_COURSE_PURCHASE(17),

    /**
     * 财务收支明细表
     */
    CW_FINANCE_RECORD(18),

    /**
     * 财务报名明细表
     */
    CW_SIGNUP_RECORD(19),

    /**
     * 财务报名-退款到明细表
     */
    CW_SIGNUP_REFUND_RECORD(20),
    
    /**
     * 从tx_message_record按月统计消息来源统计
     */
    MESSAGE_RECORD_SOURCE_MONTH(21),
    
    /**
     * 从tx_consult_user按月统计消息来源
     */
    CONSULT_USER_SOURCE_MONTH(22),
    
    /**
     * 从tx_message_record统计消息咨询来源统计
     */
    USER_SOURCE(23),
    
    /**
     * 从tx_consult_user统计线索来源
     */
    CLUE_SOURCE(24);

    private int type;
    
    private static Map<Integer, MsgSyncType> mapAll = new HashMap<Integer, MsgSyncType>();
    static{
        for(MsgSyncType msgSyncType : MsgSyncType.values()){
            mapAll.put(msgSyncType.getSyncType(), msgSyncType);
        }
    }
    
    public static MsgSyncType getMsgSyncType(int type){
        return mapAll.get(type);
    }
    
    public static List<MsgSyncType> getSyncSourceTypeList(){
        List<MsgSyncType> typeList = new ArrayList<>();
        typeList.add(USER_SOURCE);
        typeList.add(CLUE_SOURCE);
        return typeList;
    }
    public static void main(String[] args) {
        System.out.println(getSyncSourceTypeList().contains(CW_SIGNUP_RECORD));
    }

    private MsgSyncType(int type) {
        this.type = type;
    }

    public int getSyncType() {
        return this.type;
    }
}
