package com.baijia.tianxiao.dal.sync.constant;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * @title AdvisoryStatus
 * @desc 咨询的类型
 * @author cxm
 * @date 2015年9月22日
 * @version 1.0
 */
public enum AdvisoryStatus {

    /**
     * 试听课程相关的状态
     */

    HAVE_NOT_CONACT(1, "未联系学生"),

    REFUSE_TRIAL(2, "拒绝试听"),

    ACCEPT_TRIAL(3, "接受试听"),

    COMPLETE_TRIAL(4, "试听结束"),

    /**
     * 试听课程和三方通话公用状态
     */

    NEED_CALLBACK(20, "仍需回电"),

    /**
     * 三方通话的状态
     */

    INCOMING_ANSWERED(50, "来电接通"),

    INCOMING_NOT_ANSWERED(51, "来电未接"),

    ADVISORY_COMPLETE(52, "咨询完成"),

    ;

    private int code;

    private String note;

    private static Map<Integer, AdvisoryStatus> map = Maps.newHashMap();

    private AdvisoryStatus(int code, String note) {
        this.code = code;
        this.note = note;
    }

    static {
        for (AdvisoryStatus at : AdvisoryStatus.values()) {
            map.put(at.code, at);
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public static AdvisoryStatus getTypeByCode(Integer code) {
        return map.get(code);
    }

}
