
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.dal.signup.po;

import java.util.Date;

import com.baijia.tianxiao.dto.BaseDto;
import lombok.Data;

import com.baijia.tianxiao.sqlbuilder.annotation.Column;
import com.baijia.tianxiao.sqlbuilder.annotation.Entity;
import com.baijia.tianxiao.sqlbuilder.annotation.GeneratedValue;
import com.baijia.tianxiao.sqlbuilder.annotation.Id;
import com.baijia.tianxiao.sqlbuilder.annotation.Table;


/**
 * @title OrgSignupCourse
 * @desc yunying.org_signup_course
 * @author shizuwei
 * @date 2015年12月3日
 * @version 1.0
 */
@Entity
@Data
@Table(name = "org_signup_course", catalog = "yunying")
public class OrgSignupCourse extends BaseDto{
    /**
     * 主键
     */
    @Id
    @GeneratedValue
    private int id;

    /**
     * 机构id
     */
    @Column(name = "org_id")
    private Long orgId;

    /**
     * 用户id，学生id
     */
    @Column(name = "user_id")
    private Long userId;

    /**
     * 流水号
     */
    @Column(name = "signup_purchase_id")
    private Long signupPurchaseId;

    /**
     * 关联的课程
     */
    @Column(name = "org_course_id")
    private Long orgCourseId;

    /**
     * 关联的课程number
     */
    @Column(name = "org_course_number")
    private Long orgCourseNumber;

    /**
     * 课程原价 分
     */
    @Column(name = "origin_price")
    private Integer originPrice;

    /**
     * 折扣,90表示九折
     */
    @Column(name = "course_discount")
    private Integer courseDiscount;

    /**
     * 优惠金额 单位：分
     */
    @Column(name = "preferential")
    private Integer preferential;

    /**
     * 课程购买数量
     */
    @Column
    private Integer count;

    /**
     * 创建时间
     */
    @Column(name = "create_time")
    private Date createTime;

    /**
     * 支付价格 payPrice = originPrice * courseDiscount - preferential；
     */
    @Column(name = "pay_price")
    private Long payPrice;

}

    